"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RDSConnection = void 0;
const node_util_1 = require("node:util");
const operator_1 = require("./operator");
const kWrapToRDS = Symbol('kWrapToRDS');
class RDSConnection extends operator_1.Operator {
    conn;
    constructor(conn) {
        super(conn);
        this.conn = conn;
        if (!this.conn[kWrapToRDS]) {
            [
                'query',
                'beginTransaction',
                'commit',
                'rollback',
            ].forEach(key => {
                this.conn[key] = (0, node_util_1.promisify)(this.conn[key]);
            });
            this.conn[kWrapToRDS] = true;
        }
    }
    release() {
        return this.conn.release();
    }
    async _query(sql) {
        return await this.conn.query(sql);
    }
    async beginTransaction() {
        return await this.conn.beginTransaction();
    }
    async commit() {
        return await this.conn.commit();
    }
    async rollback() {
        return await this.conn.rollback();
    }
}
exports.RDSConnection = RDSConnection;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29ubmVjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9jb25uZWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHlDQUFzQztBQUN0Qyx5Q0FBc0M7QUFHdEMsTUFBTSxVQUFVLEdBQUcsTUFBTSxDQUFDLFlBQVksQ0FBQyxDQUFDO0FBRXhDLE1BQWEsYUFBYyxTQUFRLG1CQUFRO0lBQ3pDLElBQUksQ0FBMEI7SUFDOUIsWUFBWSxJQUE2QjtRQUN2QyxLQUFLLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDWixJQUFJLENBQUMsSUFBSSxHQUFHLElBQUksQ0FBQztRQUNqQixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsRUFBRTtZQUMxQjtnQkFDRSxPQUFPO2dCQUNQLGtCQUFrQjtnQkFDbEIsUUFBUTtnQkFDUixVQUFVO2FBQ1gsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLEVBQUU7Z0JBQ2QsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsR0FBRyxJQUFBLHFCQUFTLEVBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO1lBQzdDLENBQUMsQ0FBQyxDQUFDO1lBQ0gsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRyxJQUFJLENBQUM7U0FDOUI7SUFDSCxDQUFDO0lBRUQsT0FBTztRQUNMLE9BQU8sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUM3QixDQUFDO0lBRUQsS0FBSyxDQUFDLE1BQU0sQ0FBQyxHQUFXO1FBQ3RCLE9BQU8sTUFBTSxJQUFJLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQztJQUNwQyxDQUFDO0lBRUQsS0FBSyxDQUFDLGdCQUFnQjtRQUNwQixPQUFPLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxnQkFBZ0IsRUFBRSxDQUFDO0lBQzVDLENBQUM7SUFFRCxLQUFLLENBQUMsTUFBTTtRQUNWLE9BQU8sTUFBTSxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO0lBQ2xDLENBQUM7SUFFRCxLQUFLLENBQUMsUUFBUTtRQUNaLE9BQU8sTUFBTSxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxDQUFDO0lBQ3BDLENBQUM7Q0FDRjtBQXJDRCxzQ0FxQ0MifQ==