/// <reference types="node" />
import diagnosticsChannel from 'node:diagnostics_channel';
import type { PoolConnectionPromisify } from './types';
import type { RDSClient } from './client';
declare const _default: {
    connectionNew: diagnosticsChannel.Channel;
    connectionAcquire: diagnosticsChannel.Channel;
    connectionRelease: diagnosticsChannel.Channel;
    connectionEnqueue: diagnosticsChannel.Channel;
    queryStart: diagnosticsChannel.Channel;
    queryEnd: diagnosticsChannel.Channel;
};
export default _default;
export interface ConnectionMessage {
    client: RDSClient;
    connection: PoolConnectionPromisify;
}
export interface ConnectionEnqueueMessage {
    client: RDSClient;
}
export interface QueryStartMessage {
    connection: PoolConnectionPromisify;
    sql: string;
}
export interface QueryEndMessage {
    connection: PoolConnectionPromisify;
    sql: string;
    duration: number;
    error?: Error;
}
