var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { EJSON } from 'bson';
import { ERRORS } from '../const/code';
import { UpdateSerializer } from '../serializer/update';
import { serialize } from '../serializer/datatype';
import { Util } from '../util';
var GET_DOC = 'database.getInTransaction';
var UPDATE_DOC = 'database.updateDocInTransaction';
var DELETE_DOC = 'database.deleteDocInTransaction';
var INSERT_DOC = 'database.insertDocInTransaction';
var DocumentReference = (function () {
    function DocumentReference(transaction, coll, docID) {
        this._coll = coll;
        this.id = docID;
        this._transaction = transaction;
        this._request = this._transaction.getRequestMethod();
        this._transactionId = this._transaction.getTransactionId();
    }
    DocumentReference.prototype.create = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var params, res, inserted, ok;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        params = {
                            collectionName: this._coll,
                            transactionId: this._transactionId,
                            data: EJSON.stringify(serialize(data), { relaxed: false })
                        };
                        if (this.id) {
                            params['_id'] = this.id;
                        }
                        return [4, this._request.send(INSERT_DOC, params)];
                    case 1:
                        res = _a.sent();
                        if (res.code) {
                            throw res;
                        }
                        inserted = EJSON.parse(res.inserted);
                        ok = EJSON.parse(res.ok);
                        if (ok == 1 && inserted == 1) {
                            return [2, __assign(__assign({}, res), { ok: ok,
                                    inserted: inserted })];
                        }
                        else {
                            throw new Error(ERRORS.INSERT_DOC_FAIL.message);
                        }
                        return [2];
                }
            });
        });
    };
    DocumentReference.prototype.get = function () {
        return __awaiter(this, void 0, void 0, function () {
            var param, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        param = {
                            collectionName: this._coll,
                            transactionId: this._transactionId,
                            query: {
                                _id: { $eq: this.id }
                            }
                        };
                        return [4, this._request.send(GET_DOC, param)];
                    case 1:
                        res = _a.sent();
                        if (res.code)
                            throw res;
                        return [2, {
                                data: res.data !== 'null' ? Util.formatField(EJSON.parse(res.data)) : EJSON.parse(res.data),
                                requestId: res.requestId
                            }];
                }
            });
        });
    };
    DocumentReference.prototype.set = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var param, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        param = {
                            collectionName: this._coll,
                            transactionId: this._transactionId,
                            query: {
                                _id: { $eq: this.id }
                            },
                            data: EJSON.stringify(serialize(data), { relaxed: false }),
                            upsert: true
                        };
                        return [4, this._request.send(UPDATE_DOC, param)];
                    case 1:
                        res = _a.sent();
                        if (res.code)
                            throw res;
                        return [2, __assign(__assign({}, res), { updated: EJSON.parse(res.updated), upserted: res.upserted
                                    ? JSON.parse(res.upserted)
                                    : null })];
                }
            });
        });
    };
    DocumentReference.prototype.update = function (data) {
        return __awaiter(this, void 0, void 0, function () {
            var param, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        param = {
                            collectionName: this._coll,
                            transactionId: this._transactionId,
                            query: {
                                _id: { $eq: this.id }
                            },
                            data: EJSON.stringify(UpdateSerializer.encode(data), {
                                relaxed: false
                            })
                        };
                        return [4, this._request.send(UPDATE_DOC, param)];
                    case 1:
                        res = _a.sent();
                        if (res.code)
                            throw res;
                        return [2, __assign(__assign({}, res), { updated: EJSON.parse(res.updated) })];
                }
            });
        });
    };
    DocumentReference.prototype.delete = function () {
        return __awaiter(this, void 0, void 0, function () {
            var param, res;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        param = {
                            collectionName: this._coll,
                            transactionId: this._transactionId,
                            query: {
                                _id: { $eq: this.id }
                            }
                        };
                        return [4, this._request.send(DELETE_DOC, param)];
                    case 1:
                        res = _a.sent();
                        if (res.code)
                            throw res;
                        return [2, __assign(__assign({}, res), { deleted: EJSON.parse(res.deleted) })];
                }
            });
        });
    };
    return DocumentReference;
}());
export { DocumentReference };
