var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { DocumentReference } from './document';
import { Query } from './query';
var CollectionReference = (function (_super) {
    __extends(CollectionReference, _super);
    function CollectionReference(transaction, coll) {
        return _super.call(this, transaction, coll) || this;
    }
    Object.defineProperty(CollectionReference.prototype, "name", {
        get: function () {
            return this._coll;
        },
        enumerable: true,
        configurable: true
    });
    CollectionReference.prototype.doc = function (docID) {
        if (typeof docID !== 'string' && typeof docID !== 'number') {
            throw new Error('docId必须为字符串或数字');
        }
        return new DocumentReference(this._transaction, this._coll, docID);
    };
    CollectionReference.prototype.add = function (data) {
        var docID;
        if (data._id !== undefined) {
            docID = data._id;
        }
        var docRef = new DocumentReference(this._transaction, this._coll, docID);
        return docRef.create(data);
    };
    return CollectionReference;
}(Query));
export { CollectionReference };
