"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const bson_1 = require("bson");
const symbol_1 = require("../helper/symbol");
class Decimal128Type {
    constructor(decimalStr = '') {
        if (typeof decimalStr !== 'string') {
            throw new TypeError(`Decimal128Type 入参必须为 string!`);
        }
        this.decimalStr = decimalStr;
    }
    get _internalType() {
        return symbol_1.SYMBOL_DECIMAL128;
    }
    parse() {
        return bson_1.Decimal128.fromString(this.decimalStr);
    }
    toJSON() {
        return bson_1.Decimal128.fromString(this.decimalStr);
    }
}
exports.Decimal128Type = Decimal128Type;
function Decimal128TypeConstructor(decimalStr) {
    return new Decimal128Type(decimalStr);
}
exports.Decimal128TypeConstructor = Decimal128TypeConstructor;
