"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.USER_AGENT = exports.HttpClient2 = exports.HttpClient = exports.getGlobalDispatcher = exports.setGlobalDispatcher = exports.Dispatcher = exports.Agent = exports.ProxyAgent = exports.MockAgent = exports.curl = exports.request = void 0;
const ylru_1 = __importDefault(require("ylru"));
const HttpClient_js_1 = require("./HttpClient.js");
let httpclient;
const domainSocketHttpclients = new ylru_1.default(50);
async function request(url, options) {
    if (options?.socketPath) {
        let domainSocketHttpclient = domainSocketHttpclients.get(options.socketPath);
        if (!domainSocketHttpclient) {
            domainSocketHttpclient = new HttpClient_js_1.HttpClient({
                connect: { socketPath: options.socketPath },
            });
            domainSocketHttpclients.set(options.socketPath, domainSocketHttpclient);
        }
        return await domainSocketHttpclient.request(url, options);
    }
    if (!httpclient) {
        httpclient = new HttpClient_js_1.HttpClient({});
    }
    return await httpclient.request(url, options);
}
exports.request = request;
// export curl method is keep compatible with urlib.curl()
// ```ts
// import * as urllib from 'urllib';
// urllib.curl(url);
// ```
async function curl(url, options) {
    return await request(url, options);
}
exports.curl = curl;
var undici_1 = require("undici");
Object.defineProperty(exports, "MockAgent", { enumerable: true, get: function () { return undici_1.MockAgent; } });
Object.defineProperty(exports, "ProxyAgent", { enumerable: true, get: function () { return undici_1.ProxyAgent; } });
Object.defineProperty(exports, "Agent", { enumerable: true, get: function () { return undici_1.Agent; } });
Object.defineProperty(exports, "Dispatcher", { enumerable: true, get: function () { return undici_1.Dispatcher; } });
Object.defineProperty(exports, "setGlobalDispatcher", { enumerable: true, get: function () { return undici_1.setGlobalDispatcher; } });
Object.defineProperty(exports, "getGlobalDispatcher", { enumerable: true, get: function () { return undici_1.getGlobalDispatcher; } });
// HttpClient2 is keep compatible with urlib@2 HttpClient2
var HttpClient_js_2 = require("./HttpClient.js");
Object.defineProperty(exports, "HttpClient", { enumerable: true, get: function () { return HttpClient_js_2.HttpClient; } });
Object.defineProperty(exports, "HttpClient2", { enumerable: true, get: function () { return HttpClient_js_2.HttpClient; } });
Object.defineProperty(exports, "USER_AGENT", { enumerable: true, get: function () { return HttpClient_js_2.HEADER_USER_AGENT; } });
exports.default = {
    request,
    curl,
    USER_AGENT: HttpClient_js_1.HEADER_USER_AGENT,
};
