import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface SpiAlipayMerchantOrderJourneyBatchqueryOptions extends BaseOpenapiOptions {
    alipay_user_id?: string;
    merchant_journey_nos: string[];
    open_id?: string;
}
export interface SpiAlipayMerchantOrderJourneyBatchqueryResult extends BaseOpenapiResult {
    error_code?: string;
    error_desc?: string;
    journey_order_list?: {
        action?: string;
        ext_info?: {
            ext_key: string;
            ext_value?: string;
        }[];
        journey_create_time: string;
        journey_desc?: string;
        journey_elements: {
            arrival?: {
                aoi_id?: string;
                city?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                location_id?: string;
                location_id_type?: string;
                merchant_division_id?: string;
                merchant_id?: string;
                merchant_poi?: string;
                name: string;
                poi_id?: string;
            };
            departure?: {
                aoi_id?: string;
                city?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                location_id?: string;
                location_id_type?: string;
                merchant_division_id?: string;
                merchant_id?: string;
                merchant_poi?: string;
                name: string;
                poi_id?: string;
            };
            duration?: string;
            end_time?: string;
            end_time_desc?: string;
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            functional_services?: {
                content?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                function_code: string;
                function_name: string;
                function_type: string;
                function_url?: string;
                memo?: string;
            }[];
            passagers?: {
                cert_no?: string;
                cert_type?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                mobile?: string;
                name?: string;
                open_id?: string;
                user_id?: string;
            }[];
            service_change_info?: {
                change_status: string;
                detail_url?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                remind_content?: string;
            };
            service_provider?: {
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                logo?: string;
                name: string;
                short_name?: string;
            };
            start_time?: string;
            start_time_desc?: string;
        }[];
        journey_index?: string;
        journey_modify_time: string;
        merchant_journey_no: string;
        status?: string;
        status_desc?: string;
        sub_type: string;
        title?: string;
        type: string;
    }[];
    success: string;
}
export interface SpiAlipayMerchantOrderJourneyBatchquery {
    request(options: SpiAlipayMerchantOrderJourneyBatchqueryOptions): Promise<SpiAlipayMerchantOrderJourneyBatchqueryResult>;
}
