import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AntMerchantExpandItemOpenCreateOptions extends BaseOpenapiOptions {
    bizContent: {
        description?: string;
        ext_info?: {
            ext_key: string;
            ext_value: string;
        }[];
        material_list?: {
            content: string;
            type: string;
        }[];
        name: string;
        property_list?: {
            property_key: string;
            property_value_list: string[];
        }[];
        scene: string;
        sku_list: {
            inventory?: number;
            material_list?: {
                content: string;
                type: string;
            }[];
            original_price: number;
            price: number;
            property_list?: {
                property_key: string;
                property_value: string;
            }[];
        }[];
        standard_category_id?: string;
        target_id: string;
        target_type: string;
        type: string;
    };
}
export interface AntMerchantExpandItemOpenCreateResult extends BaseOpenapiResult {
    item_id: string;
}
export interface AntMerchantExpandItemOpenCreate {
    request(options: AntMerchantExpandItemOpenCreateOptions): Promise<AntMerchantExpandItemOpenCreateResult>;
}
