import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayUserInfoShareResult extends BaseOpenapiResult {
    address?: string;
    age?: string;
    area?: string;
    avatar: string;
    business_scope?: string;
    cert_no?: string;
    cert_type?: string;
    city: string;
    college_name?: string;
    country_code?: string;
    degree?: string;
    deliver_addresses?: {
        address?: string;
        address_code?: string;
        default_deliver_address?: string;
        deliver_area?: string;
        deliver_city?: string;
        deliver_fullname?: string;
        deliver_mobile: string;
        deliver_phone: string;
        deliver_province?: string;
        zip?: string;
    }[];
    display_name?: string;
    email?: string;
    enrollment_time?: string;
    ent_license_address?: string;
    ent_license_area?: string;
    ent_license_city?: string;
    ent_license_province?: string;
    firm_agent_person_cert_expiry_date?: string;
    firm_agent_person_cert_no?: string;
    firm_agent_person_cert_type?: string;
    firm_agent_person_name?: string;
    firm_legal_person_cert_expiry_date?: string;
    firm_legal_person_cert_no?: string;
    firm_legal_person_cert_type?: string;
    firm_legal_person_name?: string;
    firm_legal_person_pictures?: {
        picture_type: string;
        picture_url: string;
    }[];
    firm_pictures?: {
        picture_type: string;
        picture_url: string;
    }[];
    firm_type?: string;
    gender?: string;
    graduation_time?: string;
    identity_card_address: string;
    identity_card_area: string;
    identity_card_city: string;
    identity_card_province: string;
    inst_or_corp?: string;
    is_adult?: string;
    is_balance_frozen?: string;
    is_blocked?: string;
    is_certified?: string;
    is_student_certified?: string;
    license_expiry_date?: string;
    license_no?: string;
    member_grade: string;
    mobile?: string;
    nick_name: string;
    open_id: string;
    organization_code?: string;
    person_birthday?: string;
    person_birthday_without_year: string;
    person_cert_expiry_date?: string;
    person_cert_issue_date?: string;
    person_pictures?: {
        picture_type: string;
        picture_url: string;
    }[];
    phone?: string;
    profession?: string;
    province: string;
    taobao_id?: string;
    user_id: string;
    user_name?: string;
    user_nation: string;
    user_status?: string;
    user_type?: string;
    zip?: string;
}
export interface AlipayUserInfoShare {
    request(options?: BaseOpenapiOptions): Promise<AlipayUserInfoShareResult>;
}
