import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeRefundApplyOptions extends BaseOpenapiOptions {
    bizContent: {
        extend_params?: string;
        operator_id?: string;
        out_request_no?: string;
        out_trade_no?: string;
        refund_amount: string;
        refund_fund_details?: {
            funds: string[];
            trans_in?: string;
            trans_in_type?: string;
            type: string;
        }[];
        refund_reason?: string;
        store_id?: string;
        terminal_id?: string;
        trade_no?: string;
    };
}
export interface AlipayTradeRefundApplyResult extends BaseOpenapiResult {
    out_request_no?: string;
    out_trade_no?: string;
    refund_amount?: string;
    refund_status?: string;
    trade_no?: string;
}
export interface AlipayTradeRefundApply {
    request(options: AlipayTradeRefundApplyOptions): Promise<AlipayTradeRefundApplyResult>;
}
