import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeRefundOptions extends BaseOpenapiOptions {
    bizContent: {
        goods_detail?: {
            alipay_goods_id?: string;
            body?: string;
            categories_tree?: string;
            goods_category?: string;
            goods_id: string;
            goods_name: string;
            price: string;
            quantity: number;
            show_url?: string;
        }[];
        operator_id?: string;
        org_pid?: string;
        out_request_no?: string;
        out_trade_no?: string;
        query_options?: string[];
        refund_advance_account?: string;
        refund_advance_account_type?: string;
        refund_amount: string;
        refund_currency?: string;
        refund_goods_detail?: {
            goods_id: string;
            refund_amount: string;
        }[];
        refund_reason?: string;
        refund_royalty_parameters?: {
            amount?: string;
            amount_percentage?: number;
            desc?: string;
            royalty_scene?: string;
            royalty_type?: string;
            trans_in: string;
            trans_in_name?: string;
            trans_in_type?: string;
            trans_out?: string;
            trans_out_type?: string;
        }[];
        store_id?: string;
        terminal_id?: string;
        trade_no?: string;
    };
}
export interface AlipayTradeRefundResult extends BaseOpenapiResult {
    buyer_logon_id: string;
    buyer_open_id?: string;
    buyer_user_id?: string;
    fund_change: string;
    gmt_refund_pay: string;
    has_deposit_back?: string;
    open_id: string;
    out_trade_no: string;
    present_refund_buyer_amount?: string;
    present_refund_discount_amount?: string;
    present_refund_mdiscount_amount?: string;
    refund_charge_amount?: string;
    refund_charge_info_list?: {
        charge_type?: string;
        refund_charge_fee?: string;
        refund_sub_fee_detail_list?: {
            refund_charge_fee?: string;
            switch_fee_rate?: string;
        }[];
        switch_fee_rate?: string;
    }[];
    refund_currency?: string;
    refund_detail_item_list?: {
        amount: string;
        bank_code?: string;
        fund_channel: string;
        fund_type?: string;
        real_amount?: string;
    }[];
    refund_fee: string;
    refund_hyb_amount?: string;
    refund_preset_paytool_list?: {
        amount: string[];
        assert_type_code: string;
    };
    refund_settlement_id?: string;
    send_back_fee?: string;
    store_name?: string;
    trade_no: string;
}
export interface AlipayTradeRefund {
    request(options: AlipayTradeRefundOptions): Promise<AlipayTradeRefundResult>;
}
