import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        org_pid?: string;
        out_trade_no?: string;
        query_options?: string[];
        trade_no?: string;
    };
}
export interface AlipayTradeQueryResult extends BaseOpenapiResult {
    alipay_store_id?: string;
    alipay_sub_merchant_id?: string;
    auth_trade_pay_mode?: string;
    bkagent_resp_info?: {
        bindclrissr_id?: string;
        bindpyeracctbk_id?: string;
        bindtrx_id?: string;
        bkpyeruser_code?: string;
        estter_location?: string;
    };
    body?: string;
    buyer_logon_id: string;
    buyer_open_id?: string;
    buyer_pay_amount?: string;
    buyer_user_id?: string;
    buyer_user_name?: string;
    buyer_user_type?: string;
    charge_amount?: string;
    charge_flags?: string;
    charge_info_list?: {
        charge_fee?: string;
        charge_type?: string;
        is_rating_on_switch?: string;
        is_rating_on_trade_receiver?: string;
        original_charge_fee?: string;
        sub_fee_detail_list?: {
            charge_fee?: string;
            original_charge_fee?: string;
            switch_fee_rate?: string;
        }[];
        switch_fee_rate?: string;
    }[];
    credit_biz_order_id?: string;
    credit_pay_mode?: string;
    discount_amount?: string;
    discount_goods_detail?: string;
    enterprise_pay_info?: {
        biz_info?: string;
        invoice_amount?: string;
        is_use_enterprise_pay?: boolean;
    };
    ext_infos?: string;
    fund_bill_list?: {
        amount: string;
        bank_code?: string;
        fund_channel: string;
        fund_type?: string;
        real_amount?: string;
    }[];
    hb_fq_pay_info?: {
        fq_amount?: string;
        user_install_num?: string;
    };
    hyb_amount?: string;
    industry_sepc_detail?: string;
    industry_sepc_detail_acc?: string;
    industry_sepc_detail_gov?: string;
    invoice_amount?: string;
    mdiscount_amount?: string;
    open_id?: string;
    out_trade_no: string;
    passback_params?: string;
    pay_amount?: string;
    pay_currency?: string;
    point_amount?: string;
    receipt_amount?: string;
    receipt_currency_type?: string;
    send_pay_date?: string;
    settle_amount?: string;
    settle_currency?: string;
    settle_trans_rate?: string;
    settlement_id?: string;
    store_id?: string;
    store_name?: string;
    subject?: string;
    terminal_id?: string;
    total_amount: string;
    trade_no: string;
    trade_settle_info?: {
        trade_settle_detail_list?: {
            amount: string;
            operation_dt: string;
            operation_serial_no?: string;
            operation_type: string;
            ori_trans_in?: string;
            ori_trans_out?: string;
            trans_in?: string;
            trans_out?: string;
        }[];
    };
    trade_status: string;
    trans_currency?: string;
    trans_pay_rate?: string;
    voucher_detail_list?: {
        amount: string;
        id: string;
        memo?: string;
        merchant_contribute?: string;
        name: string;
        other_contribute?: string;
        other_contribute_detail?: {
            contribute_amount: string;
            contribute_type: string;
        }[];
        purchase_ant_contribute?: string;
        purchase_buyer_contribute?: string;
        purchase_merchant_contribute?: string;
        template_id?: string;
        type: string;
    }[];
}
export interface AlipayTradeQuery {
    request(options: AlipayTradeQueryOptions): Promise<AlipayTradeQueryResult>;
}
