import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeOrderPayOptions extends BaseOpenapiOptions {
    bizContent: {
        advance_payment_type?: string;
        buyer_id?: string;
        buyer_open_id?: string;
        buyer_pay_detail?: {
            amount: string;
            pay_channel: string;
        }[];
        fulfillment_amount?: string;
        is_async_pay?: boolean;
        order_pay_mode?: string;
        out_request_no?: string;
        product_code?: string;
        total_amount?: string;
        trade_no: string;
    };
}
export interface AlipayTradeOrderPayResult extends BaseOpenapiResult {
    async_payment_mode: string;
    gmt_payment?: string;
    out_request_no?: string;
    out_trade_no: string;
    total_amount?: string;
    trade_no: string;
}
export interface AlipayTradeOrderPay {
    request(options: AlipayTradeOrderPayOptions): Promise<AlipayTradeOrderPayResult>;
}
