import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeFastpayRefundQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        org_pid?: string;
        out_request_no: string;
        out_trade_no?: string;
        query_options?: string[];
        trade_no?: string;
    };
}
export interface AlipayTradeFastpayRefundQueryResult extends BaseOpenapiResult {
    deposit_back_info?: {
        bank_ack_time?: string;
        dback_amount?: string;
        dback_status?: string;
        est_bank_receipt_time?: string;
        has_deposit_back?: string;
    };
    enterprise_pay_info?: {
        biz_info?: string;
        invoice_amount?: string;
        is_use_enterprise_pay?: boolean;
    };
    error_code?: string;
    gmt_refund_pay?: string;
    industry_sepc_detail?: string;
    out_request_no?: string;
    out_trade_no?: string;
    present_refund_buyer_amount?: string;
    present_refund_discount_amount?: string;
    present_refund_mdiscount_amount?: string;
    refund_amount?: string;
    refund_channel_list?: string;
    refund_channel_status?: string;
    refund_charge_amount?: string;
    refund_charge_info_list?: {
        charge_type?: string;
        refund_charge_fee?: string;
        refund_sub_fee_detail_list?: {
            refund_charge_fee?: string;
            switch_fee_rate?: string;
        }[];
        switch_fee_rate?: string;
    }[];
    refund_detail_item_list?: {
        amount: string;
        bank_code?: string;
        fund_channel: string;
        fund_type?: string;
        real_amount?: string;
    }[];
    refund_hyb_amount?: string;
    refund_reason?: string;
    refund_royaltys?: {
        refund_amount: string;
        result_code: string;
        royalty_type?: string;
        trans_in?: string;
        trans_in_email?: string;
        trans_out?: string;
        trans_out_email?: string;
    }[];
    refund_settlement_id?: string;
    refund_status?: string;
    send_back_fee?: string;
    total_amount?: string;
    trade_no?: string;
}
export interface AlipayTradeFastpayRefundQuery {
    request(options: AlipayTradeFastpayRefundQueryOptions): Promise<AlipayTradeFastpayRefundQueryResult>;
}
