import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayTradeAppPayOptions extends BaseOpenapiOptions {
    bizContent: {
        agreement_sign_params?: {
            access_params: {
                channel: string;
            };
            allow_huazhi_degrade?: boolean;
            external_agreement_no?: string;
            external_logon_id?: string;
            period_rule_params?: {
                execute_time: string;
                period: number;
                period_type: string;
                single_amount: string;
                total_amount?: string;
                total_payments?: number;
            };
            personal_product_code: string;
            sign_notify_url?: string;
            sign_scene: string;
            sub_merchant?: {
                sub_merchant_id?: string;
                sub_merchant_name?: string;
                sub_merchant_service_description?: string;
                sub_merchant_service_name?: string;
            };
        };
        body?: string;
        business_params?: string;
        disable_pay_channels?: string;
        enable_pay_channels?: string;
        ext_user_info?: {
            cert_no?: string;
            cert_type?: string;
            fix_buyer?: string;
            identity_hash?: string;
            min_age?: string;
            mobile?: string;
            name?: string;
            need_check_info?: string;
        };
        extend_params?: {
            card_type?: string;
            hb_fq_num?: string;
            hb_fq_seller_percent?: string;
            industry_reflux_info?: string;
            royalty_freeze?: string;
            specified_seller_name?: string;
            sys_service_provider_id?: string;
        };
        goods_detail?: {
            alipay_goods_id?: string;
            body?: string;
            categories_tree?: string;
            goods_category?: string;
            goods_id: string;
            goods_name: string;
            price: string;
            quantity: number;
            show_url?: string;
        }[];
        goods_type?: string;
        invoice_info?: {
            details: string;
            key_info: {
                invoice_merchant_name: string;
                is_support_invoice: boolean;
                tax_num: string;
            };
        };
        merchant_order_no?: string;
        out_trade_no: string;
        passback_params?: string;
        product_code?: string;
        promo_params?: string;
        query_options?: string[];
        royalty_info?: {
            royalty_detail_infos: {
                amount: string;
                amount_percentage?: string;
                batch_no: string;
                desc?: string;
                out_relation_id?: string;
                serial_no?: number;
                trans_in: string;
                trans_in_type?: string;
                trans_out: string;
                trans_out_type: string;
            }[];
            royalty_type?: string;
        };
        seller_id?: string;
        settle_info?: {
            settle_detail_infos: {
                actual_amount?: string;
                amount: string;
                settle_entity_id?: string;
                settle_entity_type?: string;
                summary_dimension?: string;
                trans_in: string;
                trans_in_type: string;
            }[];
            settle_period_time?: string;
        };
        specified_channel?: string;
        store_id?: string;
        sub_merchant?: {
            merchant_id: string;
            merchant_type?: string;
        };
        subject: string;
        time_expire?: string;
        timeout_express?: string;
        total_amount: string;
    };
}
export interface AlipayTradeAppPayResult extends BaseOpenapiResult {
    credit_agreement_id: string;
    credit_biz_order_id: string;
    credit_pay_mode: string;
    merchant_order_no: string;
    out_trade_no: string;
    seller_id: string;
    total_amount: string;
    trade_no: string;
}
export interface AlipayTradeAppPay {
    request(options: AlipayTradeAppPayOptions): Promise<AlipayTradeAppPayResult>;
}
