import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipaySystemOauthTokenOptions extends BaseOpenapiOptions {
    code?: string;
    grant_type: string;
    refresh_token?: string;
}
export interface AlipaySystemOauthTokenResult extends BaseOpenapiResult {
    access_token: string;
    alipay_user_id?: string;
    auth_start?: string;
    auth_token_type?: string;
    expires_in: string;
    open_id: string;
    re_expires_in: string;
    refresh_token: string;
    union_id?: string;
    user_id: string;
}
export interface AlipaySystemOauthToken {
    request(options: AlipaySystemOauthTokenOptions): Promise<AlipaySystemOauthTokenResult>;
}
