import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayOpenSearchOrderdetailQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        biz_data: {
            apply_id?: string;
            apply_type?: string;
            brand_template_id?: string;
            service_code?: string;
            spec_code?: string;
        };
        biz_type: string;
        opt_type?: string;
    };
}
export interface AlipayOpenSearchOrderdetailQueryResult extends BaseOpenapiResult {
    data: {
        access_type?: string;
        app_category?: string;
        app_icon?: string;
        app_name?: string;
        app_status?: string;
        appid?: string;
        base_order_status?: {
            order_id?: string;
            reject_reason?: string;
            status?: string;
        };
        biz_id?: string;
        box_order_status?: {
            order_id?: string;
            reject_reason?: string;
            status?: string;
        };
        box_status?: string;
        brand_template_id?: string;
        brandbox_orderstatus?: {
            order_id?: string;
            reject_reason?: string;
            status?: string;
        };
        can_modify_keyword?: boolean;
        describe?: string;
        detail_base_items?: {
            can_search?: string;
            desc?: string;
            img?: string;
            key_word?: string;
            name?: string;
            region?: string;
            serv_can_search?: string;
            serv_search_keywords?: string;
            template_id?: string;
            url?: string;
        };
        detail_brand_items?: {
            biz_id?: string;
            box_status?: string;
            brand_box_keywords?: string;
            brand_detail_list?: {
                brand_detail?: {
                    block_type?: string;
                    box_version?: string;
                    desc?: string;
                    img?: string;
                    index?: string;
                    key?: string;
                    material_id?: string;
                    name?: string;
                    public_bind_app_id?: string;
                    service_code?: string;
                };
                key?: string;
            }[];
            brand_template_id?: string;
            channel?: string;
            merchant_type?: string;
            template_id?: string;
        };
        detail_service_items?: {
            area_codes?: string;
            carrier_code?: string;
            carrier_list?: string;
            category_attribute_value?: string;
            category_code?: string;
            category_ids?: string;
            channel_type?: string;
            desc?: string;
            img?: string;
            key_word?: string;
            key_word_list?: string;
            logo?: string;
            name?: string;
            parent_service_code?: string;
            region?: string;
            serv_search_catalogs?: string;
            serv_search_keywords?: string;
            service_code?: string;
            service_name?: string;
            service_time_end?: string;
            service_time_start?: string;
            short_desc?: string;
            spec_code?: string;
            template_id?: string;
        };
        final_status?: string;
        gmtmodified?: string;
        keyword_gmt_modified?: string;
        online_time?: string;
        operator_type?: string;
        order_id?: string;
        partner_type?: string;
        reject_node?: string;
        reject_reason?: string;
        scene_code?: string;
        scene_name?: string;
        service_code?: string;
        service_name?: string;
        status?: string;
        sub_service_code?: string;
        template_id?: string;
        template_name?: string;
    };
}
export interface AlipayOpenSearchOrderdetailQuery {
    request(options: AlipayOpenSearchOrderdetailQueryOptions): Promise<AlipayOpenSearchOrderdetailQueryResult>;
}
