import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayOpenSearchBoxQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        box_id: string;
        merchant_id?: string;
    };
}
export interface AlipayOpenSearchBoxQueryResult extends BaseOpenapiResult {
    account_module?: {
        app_infos?: {
            app_name?: string;
            app_type?: string;
            relate_appid?: string;
        }[];
        module_id?: string;
        module_type?: string;
    };
    area_keyword_module?: {
        latest_audit_area_keyword_info?: {
            apply_no?: string;
            fail_reason?: string;
            gmt_modified?: string;
            keywords?: string[];
            module_id?: string;
            status?: string;
        };
        module_id?: string;
        module_type?: string;
        valid_area_keyword_info?: {
            apply_no?: string;
            fail_reason?: string;
            gmt_modified?: string;
            keywords?: string[];
            module_id?: string;
            status?: string;
        };
    };
    basic_info_module?: {
        apply_no?: string;
        box_desc?: string;
        fail_reason?: string;
        gmt_modified?: string;
        latest_audit_box_desc?: string;
        module_id?: string;
        module_type?: string;
        status?: string;
    };
    box_id?: string;
    box_status?: string;
    business_district_module?: {
        business_district_infos?: {
            app_name?: string;
            business_district_id: string;
            business_district_name: string;
            relate_appid?: string;
            service_code?: string;
        }[];
        module_id: string;
        module_type: string;
    };
    default_keywords?: string[];
    keyword_module?: {
        apply_no?: string;
        fail_reason?: string;
        gmt_modified?: string;
        keywords?: string[];
        latest_audit_keywords?: string[];
        module_id?: string;
        module_type?: string;
        status?: string;
    };
    latest_audit_image?: {
        apply_no?: string;
        fail_reason?: string;
        gmt_modified?: string;
        module_id?: string;
        module_type?: string;
        status?: string;
    };
    service_module?: {
        module_id?: string;
        module_type?: string;
        service_infos?: {
            service_category_code?: string;
            service_category_name?: string;
            service_code?: string;
            service_name?: string;
        }[];
    };
    valid_image?: {
        apply_no?: string;
        fail_reason?: string;
        gmt_modified?: string;
        module_id?: string;
        module_type?: string;
        status?: string;
    };
}
export interface AlipayOpenSearchBoxQuery {
    request(options: AlipayOpenSearchBoxQueryOptions): Promise<AlipayOpenSearchBoxQueryResult>;
}
