import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayOpenSearchAbilityBatchqueryOptions extends BaseOpenapiOptions {
    bizContent: {
        biz_data: {
            access_type: string;
            appid?: string;
            page_num: string;
            page_size: string;
            scene_code?: string;
            spec_code?: string;
        };
        biz_type: string;
        opt_type?: string;
    };
}
export interface AlipayOpenSearchAbilityBatchqueryResult extends BaseOpenapiResult {
    data: {
        page_data?: {
            access_type?: string;
            app_name?: string;
            app_status?: string;
            appid?: string;
            apply_id?: string;
            apply_type?: string;
            audit_status?: string;
            biz_id?: string;
            box_status?: string;
            brand_template_id?: string;
            children?: {
                access_type?: string;
                app_name?: string;
                app_status?: string;
                audit_status?: string;
                biz_id?: string;
                box_status?: string;
                brand_template_id?: string;
                data_key?: string;
                gmt_modified?: string;
                id?: string;
                is_old_data?: boolean;
                major_status?: string;
                online_time?: string;
                open_status?: boolean;
                operator?: string;
                reject_reason?: string;
                scene_code?: string;
                scene_name?: string;
                search_app_id?: string;
                sepc_code?: string;
                service_code?: string;
                sub_service_desc?: string;
                sub_service_name?: string;
            }[];
            data_key?: string;
            gmt_modified?: string;
            id?: string;
            is_old_data?: string;
            major_status?: string;
            online_time?: string;
            open_status?: boolean;
            operator?: string;
            reject_reason?: string;
            scene_code?: string;
            scene_name?: string;
            service_code?: string;
            sub_service_desc?: string;
            sub_service_name?: string;
        }[];
        page_num?: string;
        page_size?: string;
        total_number?: number;
    };
}
export interface AlipayOpenSearchAbilityBatchquery {
    request(options: AlipayOpenSearchAbilityBatchqueryOptions): Promise<AlipayOpenSearchAbilityBatchqueryResult>;
}
