import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayOpenMiniVersionDetailQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        app_version: string;
        bundle_id?: string;
    };
}
export interface AlipayOpenMiniVersionDetailQueryResult extends BaseOpenapiResult {
    app_desc?: string;
    app_english_name?: string;
    app_logo?: string;
    app_name?: string;
    app_slogan?: string;
    app_version?: string;
    base_audit?: string;
    base_audit_record?: {
        audit_images?: string[];
        memos?: {
            memo?: string;
            memo_image_list?: string[];
        }[];
    };
    can_release?: string;
    gmt_apply_audit?: string;
    gmt_audit_end?: string;
    gmt_create?: string;
    gmt_offline?: string;
    gmt_online?: string;
    gray_strategy?: string;
    memo?: string;
    mini_app_category_info_list?: {
        first_category_id: string;
        first_category_name: string;
        second_category_id: string;
        second_category_name: string;
        third_category_id?: string;
        third_category_name?: string;
    }[];
    mini_category_info_list?: {
        first_category_id: string;
        first_category_name: string;
        second_category_id: string;
        second_category_name: string;
        third_category_id?: string;
        third_category_name?: string;
    }[];
    package_info_list?: {
        doc_url?: string;
        package_desc?: string;
        package_name: string;
        package_open_type: string;
        status?: string;
    }[];
    promote_audit?: string;
    promote_audit_record?: {
        audit_images?: string[];
        memos?: {
            memo?: string;
            memo_image_list?: string[];
        }[];
    };
    reject_reason?: string;
    scan_result?: string;
    screen_shot_list?: string[];
    service_email?: string;
    service_phone?: string;
    service_region_info?: {
        area_code?: string;
        area_name?: string;
        city_code?: string;
        city_name?: string;
        province_code?: string;
        province_name?: string;
    }[];
    service_region_type?: string;
    status?: string;
    version_desc?: string;
}
export interface AlipayOpenMiniVersionDetailQuery {
    request(options: AlipayOpenMiniVersionDetailQueryOptions): Promise<AlipayOpenMiniVersionDetailQueryResult>;
}
