import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayMerchantOrderSyncOptions extends BaseOpenapiOptions {
    bizContent: {
        amount?: string;
        buyer_id?: string;
        buyer_info?: {
            cert_no?: string;
            cert_type?: string;
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            mobile?: string;
            name?: string;
            open_id?: string;
            user_id?: string;
        };
        buyer_open_id?: string;
        category_id?: string;
        discount_amount?: string;
        discount_info_list?: {
            discount_amount: string;
            discount_name: string;
            discount_page_link?: string;
            discount_quantity?: number;
            external_discount_id: string;
        }[];
        ext_info?: {
            ext_key: string;
            ext_value?: string;
        }[];
        item_order_list?: {
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            item_id?: string;
            item_name: string;
            quantity?: number;
            sku_id?: string;
            status?: string;
            status_desc?: string;
            unit?: string;
            unit_price?: string;
        }[];
        journey_order_list?: {
            action?: string;
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            journey_create_time: string;
            journey_desc?: string;
            journey_elements: {
                arrival?: {
                    aoi_id?: string;
                    city?: string;
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    location_id?: string;
                    location_id_type?: string;
                    merchant_division_id?: string;
                    merchant_id?: string;
                    merchant_poi?: string;
                    name: string;
                    poi_id?: string;
                };
                departure?: {
                    aoi_id?: string;
                    city?: string;
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    location_id?: string;
                    location_id_type?: string;
                    merchant_division_id?: string;
                    merchant_id?: string;
                    merchant_poi?: string;
                    name: string;
                    poi_id?: string;
                };
                duration?: string;
                end_time?: string;
                end_time_desc?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                functional_services?: {
                    content?: string;
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    function_code: string;
                    function_name: string;
                    function_type: string;
                    function_url?: string;
                    memo?: string;
                }[];
                passagers?: {
                    cert_no?: string;
                    cert_type?: string;
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    mobile?: string;
                    name?: string;
                    open_id?: string;
                    user_id?: string;
                }[];
                service_change_info?: {
                    change_status: string;
                    detail_url?: string;
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    remind_content?: string;
                };
                service_provider?: {
                    ext_info?: {
                        ext_key: string;
                        ext_value?: string;
                    }[];
                    logo?: string;
                    name: string;
                    short_name?: string;
                };
                start_time?: string;
                start_time_desc?: string;
            }[];
            journey_index?: string;
            journey_modify_time: string;
            merchant_journey_no: string;
            status?: string;
            status_desc?: string;
            sub_type: string;
            title?: string;
            type: string;
        }[];
        logistics_info_list?: {
            logistics_code?: string;
            tracking_no: string;
        }[];
        order_auth_code?: string;
        order_create_time?: string;
        order_modified_time: string;
        order_pay_time?: string;
        order_type?: string;
        out_biz_no: string;
        partner_id?: string;
        pay_amount?: string;
        pay_timeout_express?: string;
        record_id?: string;
        seller_id?: string;
        send_msg?: string;
        service_code?: string;
        shop_info?: {
            address?: string;
            alipay_shop_id?: string;
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            merchant_shop_id?: string;
            merchant_shop_link_page?: string;
            name?: string;
            phone_num?: string;
            type?: string;
        };
        source_app?: string;
        sync_content?: string;
        ticket_info?: {
            address?: string;
            end_time?: string;
            resv_type?: string;
            shop?: string;
            ticket_no: string;
            time?: string;
            type: string;
        };
        ticket_order_list?: {
            arrival?: {
                aoi_id?: string;
                city?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                location_id?: string;
                location_id_type?: string;
                merchant_division_id?: string;
                merchant_id?: string;
                merchant_poi?: string;
                name: string;
                poi_id?: string;
            };
            content?: string;
            departure?: {
                aoi_id?: string;
                city?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                location_id?: string;
                location_id_type?: string;
                merchant_division_id?: string;
                merchant_id?: string;
                merchant_poi?: string;
                name: string;
                poi_id?: string;
            };
            effective_num?: number;
            end_time?: string;
            ext_info?: {
                ext_key: string;
                ext_value?: string;
            }[];
            face_value?: string;
            functional_services?: {
                content?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                function_code: string;
                function_name: string;
                function_type: string;
                function_url?: string;
                memo?: string;
            }[];
            invalid_reason?: string;
            locations?: {
                aoi_id?: string;
                city?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                location_id?: string;
                location_id_type?: string;
                merchant_division_id?: string;
                merchant_id?: string;
                merchant_poi?: string;
                name: string;
                poi_id?: string;
            }[];
            merchant_ticket_no: string;
            seat_infos?: {
                seat_class?: string;
                seat_no?: string;
            }[];
            service_provider?: {
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                logo_material_id?: string;
                name?: string;
                short_name?: string;
                type?: string;
                uid?: string;
            };
            shops?: {
                address?: string;
                alipay_shop_id?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                merchant_shop_id?: string;
                merchant_shop_link_page?: string;
                name?: string;
                phone_num?: string;
                type?: string;
            }[];
            start_time?: string;
            status?: string;
            ticket_create_time: string;
            ticket_modify_time: string;
            ticket_num?: number;
            ticket_users?: {
                cert_no?: string;
                cert_type?: string;
                ext_info?: {
                    ext_key: string;
                    ext_value?: string;
                }[];
                mobile?: string;
                name?: string;
                open_id?: string;
                user_id?: string;
            }[];
            title?: string;
            vehicle_info?: {
                license_plate_no?: string;
                memo?: string;
                shift_no?: string;
            };
        }[];
        trade_no?: string;
        trade_type?: string;
    };
}
export interface AlipayMerchantOrderSyncResult extends BaseOpenapiResult {
    distribute_result?: {
        not_distribute_reason?: string;
        scene_code?: string;
        scene_name?: string;
    }[];
    order_id?: string;
    order_status?: string;
    record_id?: string;
    sync_suggestions?: {
        message?: string;
        type?: string;
    }[];
}
export interface AlipayMerchantOrderSync {
    request(options: AlipayMerchantOrderSyncOptions): Promise<AlipayMerchantOrderSyncResult>;
}
