import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayMarketingActivityDeliveryStopOptions extends BaseOpenapiOptions {
    bizContent: {
        belong_merchant_info?: {
            business_type: string;
            merchant_id?: string;
            merchant_id_type?: string;
        };
        delivery_config_list?: {
            activity_id: string;
            booth_code: string;
            channel: string;
        }[];
        delivery_id: string;
        merchant_access_mode?: string;
        out_biz_no: string;
    };
}
export interface AlipayMarketingActivityDeliveryStopResult extends BaseOpenapiResult {
    delivery_id: string;
    error_delivery_config_list?: {
        delivery_config: {
            activity_id: string;
            booth_code: string;
            channel: string;
        };
        error_code: string;
        error_msg: string;
    }[];
    success_delivery_config_list?: {
        delivery_config: {
            activity_id: string;
            booth_code: string;
            channel: string;
        };
    }[];
}
export interface AlipayMarketingActivityDeliveryStop {
    request(options: AlipayMarketingActivityDeliveryStopOptions): Promise<AlipayMarketingActivityDeliveryStopResult>;
}
