import { BaseOpenapiOptions, BaseOpenapiResult } from './common';
export interface AlipayMarketingActivityDeliveryQueryOptions extends BaseOpenapiOptions {
    bizContent: {
        belong_merchant_info?: {
            business_type: string;
            merchant_id?: string;
            merchant_id_type?: string;
        };
        delivery_config_list: {
            activity_id: string;
            booth_code: string;
            channel: string;
        }[];
        delivery_id: string;
        merchant_access_mode?: string;
    };
}
export interface AlipayMarketingActivityDeliveryQueryResult extends BaseOpenapiResult {
    delivery_base_info: {
        delivery_begin_time: string;
        delivery_end_time: string;
        delivery_material: {
            delivery_single_material: {
                delivery_image: string;
            };
            material_id_list?: string[];
        };
        delivery_name: string;
    };
    delivery_booth_code: string;
    delivery_error_msg: string;
    delivery_id: string;
    delivery_info_list?: {
        activity_id: string;
        booth_code: string;
        channel: string;
        channel_name: string;
        delivery_status: string;
    }[];
    delivery_play_config: {
        delivery_full_send_config?: {
            delivery_content_info: {
                delivery_activity_content?: {
                    activity_id?: string;
                };
                delivery_app_content?: {
                    mini_app_delivery_type: string;
                    mini_app_id: string;
                    service_code_list: string[];
                };
                delivery_content_type: string;
            };
            delivery_floor_amount: string;
        };
        delivery_single_send_config?: {
            delivery_content_config?: {
                delivery_send_guide?: {
                    delivery_guide_url: string;
                };
            };
            delivery_content_info: {
                delivery_activity_content?: {
                    activity_id?: string;
                };
                delivery_app_content?: {
                    mini_app_delivery_type: string;
                    mini_app_id: string;
                    service_code_list: string[];
                };
                delivery_content_type: string;
            };
        };
    };
    delivery_status: string;
    delivery_target_rule: {
        brand_id_list?: string[];
        delivery_available_scope?: {
            delivery_available_city_code?: {
                all_city?: boolean;
                city_codes?: string[];
            };
            delivery_available_scope_type: string;
        };
        delivery_city_code_rule?: {
            all_city?: boolean;
            city_codes?: string[];
        };
        delivery_merchant_infos?: {
            merchant_id: string;
            merchant_id_type: string;
        }[];
        delivery_merchant_mode?: string;
        delivery_merchant_rule?: {
            brand_id_list?: string[];
            delivery_merchant_infos?: {
                merchant_id: string;
                merchant_id_type: string;
            }[];
            delivery_merchant_mode: string;
        };
        delivery_promo_tags?: string;
        delivery_recall_mode?: string;
        delivery_search_box_rule?: {
            box_id?: string;
        };
        delivery_type?: string;
    };
}
export interface AlipayMarketingActivityDeliveryQuery {
    request(options: AlipayMarketingActivityDeliveryQueryOptions): Promise<AlipayMarketingActivityDeliveryQueryResult>;
}
