import type { Readable } from 'node:stream';
import type { RequestOptions } from 'urllib';
import type { CloudConfig } from '@alipay/faas-server-utils';
import type { CallFunctionParam as SDKCallFunctionParam, UploadFileParam as SDKUploadFileParam } from '@alipay/faas-common-sdk';
export type CloudInitOptions = {
    env?: string | symbol | {
        database?: string | symbol;
        functions?: string | symbol;
        storage?: string | symbol;
    };
    timeout?: number | [number, number];
    envId?: string;
    traceUser?: boolean;
};
export type GetDatabaseOptions = {
    env?: string | symbol;
    throwOnNotFound?: boolean;
    ignoreCollectionExists?: boolean;
    timeout?: number | [number, number];
};
export interface DatabaseCloudConfig extends CloudConfig {
    throwOnNotFound: boolean;
    ignoreCollectionExists?: boolean;
}
export interface CallFunctionParam extends SDKCallFunctionParam {
    config?: {
        env?: string | symbol;
    };
}
export interface HttpRequest {
    url: URL;
    signedBody?: string;
    requestOptions: RequestOptions;
}
export interface CollectionDescription {
    coll_name: string;
}
export interface AddOneDocumentResult {
    _id: string;
}
export interface AddManyDocumentsResult {
    _ids: string[];
}
export type AddDocumentResult = AddOneDocumentResult | AddManyDocumentsResult;
export type UploadFileParam = SDKUploadFileParam<Buffer | Readable>;
export interface UploadFileResult {
    fileID: string;
    statusCode: number;
}
export interface DownloadFileResult {
    fileContent: Buffer;
    statusCode: number;
}
export interface OpenapiConfig {
    version?: string;
    sandbox?: boolean;
}
export interface CallContext {
    appId: string;
    traceId: string;
    requestId: string;
    rpcId: string;
}
