"use strict";var __importDefault=this&&this.__importDefault||function(a){return a&&a.__esModule?a:{default:a}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.Httpclient=void 0;const node_assert_1=__importDefault(require("node:assert")),node_crypto_1=require("node:crypto"),node_diagnostics_channel_1=__importDefault(require("node:diagnostics_channel")),koa_compose_1=__importDefault(require("koa-compose")),faas_server_utils_1=require("@alipay/faas-server-utils"),constant_1=require("../constant"),HttpRequestContext_1=require("./HttpRequestContext"),bson_middleware_1=require("./middlewares/bson_middleware"),call_middleware_1=require("./middlewares/call_middleware"),error_handler_middleware_1=require("./middlewares/error_handler_middleware"),init_call_dataproxy_headers_middleware_1=require("./middlewares/init_call_dataproxy_headers_middleware"),init_call_functiongateway_headers_middleware_1=require("./middlewares/init_call_functiongateway_headers_middleware"),init_call_websocketgateway_headers_middleware_1=require("./middlewares/init_call_websocketgateway_headers_middleware"),body_middleware_1=require("./middlewares/body_middleware"),sign_middleware_factory_1=require("./middlewares/sign_middleware_factory"),debug=(0,faas_server_utils_1.debuglog)("faas-server-sdk:httpRequest");class Httpclient{#t;#e;#r;constructor(t,e,s){(0,node_assert_1.default)(e,"cloud config not set"),this.#t=t,this.#e=e,this.#r=(0,koa_compose_1.default)(s)}async request(t){return(await this.requestRaw(t)).result}async requestRaw({method:t,path:e,data:s,headers:r}){const o=this.#e[this.#t]+e,i=(0,faas_server_utils_1.getAlipayContext)();r=r||{},r["x-alipay-callid"]=r["x-request-id"]=i.TRACEID||(0,node_crypto_1.randomUUID)();let n=process.env.RUNTIME_CURRENT_SOURCE||"alipay_unknown";process.env.RUNTIME_FUNCTION_NAME&&(n=`${n}:${i.ENV}:${process.env.RUNTIME_FUNCTION_NAME}`);const c=i.SOURCE||"alipay_unknown";r["x-alipay-source"]=`${c},${n}`,r["user-agent"]=constant_1.SDK_USER_AGENT,r["x-alipay-req-source"]=i.REQUEST_SOURCE,r.soure_app=i.SOURCE_APP;const d={method:t,contentType:"application/json",content:s,dataType:"json",headers:r};this.#e.timeout!==void 0&&(d.timeout=this.#e.timeout),debug("requestRaw(url:%o, options:%o)",o,d);const u={url:new URL(o),requestOptions:d},l=new HttpRequestContext_1.HttpRequestContext(u,this.#e);return await this.#r(l),l}static createFunctionHttpclient(t){const e=[error_handler_middleware_1.errorHandlerMiddleware,body_middleware_1.bodyMiddleware,(0,init_call_functiongateway_headers_middleware_1.createInitCallFunctionGatewayHeadersMiddleware)(),(0,sign_middleware_factory_1.signMiddlewareFactory)(["x-to-function-name"]),call_middleware_1.callMiddleware];return new Httpclient("functionGatewayEndpoint",t,e)}static createDatabaseHttpclient(t){const e=[error_handler_middleware_1.errorHandlerMiddleware,bson_middleware_1.bsonMiddleware,(0,init_call_dataproxy_headers_middleware_1.createInitCallDataProxyHeadersMiddleware)("mongo"),(0,sign_middleware_factory_1.signMiddlewareFactory)(["x-data-api-type","x-expire-timestamp"]),call_middleware_1.callMiddleware];return new Httpclient("functionDatabaseEndpoint",t,e)}static createStorageHttpclient(t){const e=[error_handler_middleware_1.errorHandlerMiddleware,body_middleware_1.bodyMiddleware,(0,init_call_dataproxy_headers_middleware_1.createInitCallDataProxyHeadersMiddleware)("oss"),(0,sign_middleware_factory_1.signMiddlewareFactory)(["x-data-api-type","x-expire-timestamp"],{decodePath:!0}),call_middleware_1.callMiddleware];return new Httpclient("functionStorageEndpoint",t,e)}static createOpenapiHttpclient(t){const e=[error_handler_middleware_1.errorHandlerMiddleware,body_middleware_1.bodyMiddleware,(0,init_call_functiongateway_headers_middleware_1.createInitCallFunctionGatewayHeadersMiddleware)(),(0,sign_middleware_factory_1.signMiddlewareFactory)(["x-openapi","x-openapi-version"]),call_middleware_1.callMiddleware];return new Httpclient("functionGatewayEndpoint",t,e)}static createWebsocketHttpclient(t){const e=[error_handler_middleware_1.errorHandlerMiddleware,body_middleware_1.bodyMiddleware,(0,init_call_websocketgateway_headers_middleware_1.createInitCallWebsocketGatewayHeadersMiddleware)(),(0,sign_middleware_factory_1.signMiddlewareFactory)([]),call_middleware_1.callMiddleware];return new Httpclient("websocketGatewayEndpoint",t,e)}}exports.Httpclient=Httpclient,debug.enabled&&(node_diagnostics_channel_1.default.subscribe("urllib:request",a=>{const{request:t}=a;debug("[urllib:request] request#%s %s %o, headers: %o",t.requestId,t.args.method,t.url,t.args.headers)}),node_diagnostics_channel_1.default.subscribe("urllib:response",a=>{const{request:t,response:e,error:s}=a;debug("[urllib:response] request#%s got response %s, status: %o, size: %o, headers: %o, rt: %o, timing: %o, socket: %o, requestUrls: %o",t.requestId,s?"error":"success",e.status,e.size,e.headers,e.rt,e.timing,e.socket,e.requestUrls),s&&debug("[urllib:response] %s",s)}));