import { Middleware } from 'koa-compose';
import { CloudConfig } from '@alipay/faas-server-utils';
import { HttpRequestOptions, HttpResponse } from '@alipay/faas-common-sdk';
import { HttpRequestContext } from './HttpRequestContext';
type MiddlewareArray = Array<Middleware<HttpRequestContext<unknown, unknown>>>;
type EndpointKey = 'functionGatewayEndpoint' | 'functionStorageEndpoint' | 'functionDatabaseEndpoint' | 'websocketGatewayEndpoint';
export declare class Httpclient {
    #private;
    constructor(endpointKey: EndpointKey, config: CloudConfig, middlewares: MiddlewareArray);
    request<R>(options: HttpRequestOptions): Promise<HttpResponse<R>>;
    requestRaw<T, R>({ method, path, data, headers }: HttpRequestOptions): Promise<HttpRequestContext<T, R>>;
    static createFunctionHttpclient(config: CloudConfig): Httpclient;
    static createDatabaseHttpclient(config: CloudConfig): Httpclient;
    static createStorageHttpclient(config: CloudConfig): Httpclient;
    static createOpenapiHttpclient(config: CloudConfig): Httpclient;
    static createWebsocketHttpclient(config: CloudConfig): Httpclient;
}
export {};
