import { Cloud } from './Cloud';
declare const cloud: Cloud;
export default cloud;
export declare const refreshConfig: () => void;
export declare const init: (config?: import("./types").CloudInitOptions) => void;
export declare const getAlipayContext: () => import("@alipay/faas-server-utils").AlipayContext;
export declare const callFunction: <T = any>(param: import("./types").CallFunctionParam) => Promise<import("@alipay/faas-common-sdk").CallFunctionResult<T>>;
export declare const database: (config?: import("./types").GetDatabaseOptions) => import("./Database").Database;
export declare const mysql: () => import("./MySQL").MySQL;
export declare const redis: (options?: import("./Redis").RedisOptions | string) => import("./Redis").Redis;
export declare const openapi: import("./Openapi").OpenapiFunction;
export declare const getUploadFileURL: (cloudPath: string | import("@alipay/faas-common-sdk").GetUploadFileURLParam) => Promise<import("@alipay/faas-common-sdk").GetUploadFileURLResult>;
export declare const uploadFile: (param: import("./types").UploadFileParam) => Promise<import("./types").UploadFileResult>;
export declare const downloadFile: (param: import("@alipay/faas-common-sdk").DownloadFileParam) => Promise<import("./types").DownloadFileResult>;
export declare const deleteFile: (param: import("@alipay/faas-common-sdk").DeleteFileParam) => Promise<import("@alipay/faas-common-sdk").DeleteFileResult>;
export declare const getTempFileURL: (param: import("@alipay/faas-common-sdk").GetTempFileURLParam) => Promise<import("@alipay/faas-common-sdk").GetTempFileURLResult>;
export declare const ws: () => import("./Websocket").WebsocketSDK;
export { Cloud, initRuntimeEnv } from './Cloud';
export { DYNAMIC_CURRENT_ENV } from './constant';
export { Sort } from '@alipay/faas-db-builder';
export { AlipayFormData, IField, IFile } from './Openapi/formData';
export * from './types';
export * from './types/openapi';
export type { OpenapiFunction } from './Openapi';
export type { UpdateData, DocumentData, AddDocumentParam, SampleAggregateParam } from '@alipay/faas-db-builder';
