import { CloudConfig } from '@alipay/faas-server-utils';
export interface WebSocketData {
    type: 'TEXT' | 'BINARY';
    payload: string;
}
export interface ToOneResponse {
    success: boolean;
    requestID: string;
}
export interface ToManyResponse {
    successCount: number;
    allCount: number;
    failedConnIds: string[];
    requestID: string;
}
export interface IsAliveManyResponse {
    aliveCount: number;
    allCount: number;
    aliveConnIds: string[];
    deadConnIds: string[];
    requestID: string;
}
export interface IsAliveOneResponse {
    isAlive: boolean;
    requestID: string;
}
export interface WebSocketCloseOptions {
    status?: 'NORMAL' | 'GOING_AWAY' | 'PROTOCOL_ERROR' | 'BAD_DATA' | 'TOO_BIG_TO_PROCESS' | 'SERVER_ERROR' | 'SERVICE_RESTARTED' | 'SERVICE_OVERLOAD' | 'USER_STATUS_1' | 'USER_STATUS_2' | 'USER_STATUS_3' | string;
}
export declare class WebsocketSDK {
    #private;
    constructor(config: CloudConfig);
    send(connectionId: string[], data: any): Promise<ToManyResponse>;
    send(connectionId: string, data: any): Promise<ToOneResponse>;
    close(connectionId: string[], opts?: WebSocketCloseOptions): Promise<ToManyResponse>;
    close(connectionId: string, opts?: WebSocketCloseOptions): Promise<ToOneResponse>;
    isAlive(connectionId: string[]): Promise<IsAliveManyResponse>;
    isAlive(connectionId: string): Promise<IsAliveOneResponse>;
}
