import { Readable } from 'node:stream';
export interface IFile {
    name: string;
    fieldName: string;
    path?: string;
    stream?: Readable;
    content?: Buffer;
}
export interface IField {
    name: string;
    value: string | object;
}
export declare class AlipayFormData {
    #private;
    constructor();
    getFields(): IField[];
    getFiles(): IFile[];
    addField(fieldName: string, fieldValue: any): this;
    addFile(fieldName: string, fileName: string, filePath: string | Readable | Buffer): this;
}
export interface FormDataBodyOptions {
    minChunkSize?: number;
}
export declare class FormDataBody {
    #private;
    constructor(opts?: FormDataBodyOptions);
    signedBody(): string;
    addField(fieldName: string, value: any): this;
    addFile(file: IFile): void;
    toReadable(): Readable;
    headers(): Record<string, any>;
    static createFromAlipayFormData(formData: AlipayFormData): FormDataBody;
}
