import type { RDSTransaction } from 'ali-rds/lib/transaction';
import { DeleteResult, InsertOption, InsertResult, SelectOption, UpdateOption, UpdateResult } from 'ali-rds/lib/types';
export declare class MySQLTransaction {
    #private;
    constructor(transaction: RDSTransaction);
    query<T = any>(sql: string, values?: object | any[]): Promise<T>;
    insert(table: string, rows: object | object[], option?: InsertOption): Promise<InsertResult>;
    update(table: string, row: object, option?: UpdateOption): Promise<UpdateResult>;
    select(table: string, option?: SelectOption): Promise<any[]>;
    get(table: string, where?: object, option?: SelectOption): Promise<any>;
    delete(table: string, where?: object): Promise<DeleteResult>;
    count(table: string, where?: object): Promise<number>;
    commit(): Promise<void>;
    rollback(): Promise<void>;
}
