import { CloudConfig } from '@alipay/faas-server-utils';
import { DeleteResult, UpdateResult } from 'ali-rds/lib/types';
import type { InsertOption, InsertResult, SelectOption, UpdateOption } from 'ali-rds/lib/types';
import { MySQLTransaction } from './transaction';
export declare class MySQL {
    #private;
    constructor(config: CloudConfig);
    query<T = any>(sql: string, values?: object | any[]): Promise<T>;
    insert(table: string, rows: object | object[], option?: InsertOption): Promise<InsertResult>;
    update(table: string, row: object, option?: UpdateOption): Promise<UpdateResult>;
    select(table: string, option?: SelectOption): Promise<any[]>;
    get(table: string, where?: object, option?: SelectOption): Promise<any>;
    delete(table: string, where?: object): Promise<DeleteResult>;
    count(table: string, where?: object): Promise<number>;
    beginTransaction(): Promise<MySQLTransaction>;
    beginTransactionScope(scope: (transaction: MySQLTransaction) => Promise<any>): Promise<any>;
}
