import { Command, Geo, RegExpParam, Regex } from '@alipay/faas-db-builder';
import type { DeleteDocumentResult } from '@alipay/faas-common-sdk';
import { HttpMethod } from '@alipay/faas-common-sdk';
import { CollectionDescription, DatabaseCloudConfig } from '../types';
import { Collection } from './Collection';
import { Transaction } from './Transaction';
export declare class Database {
    #private;
    command: Command;
    Geo: Geo;
    constructor(config: DatabaseCloudConfig);
    RegExp(param: RegExpParam): Regex;
    regexp(param: RegExpParam): Regex;
    regex(param: RegExpParam): Regex;
    collection(collectionName: string): Collection;
    requestRaw(method: HttpMethod, path: string, data?: object, headers?: Record<string, string>): Promise<import("urllib").HttpClientResponse<unknown>>;
    createCollection(collectionName: string): Promise<CollectionDescription>;
    getCollection(collectionName: string): Promise<CollectionDescription>;
    listCollection(limit?: number, skip?: number): Promise<Array<CollectionDescription>>;
    deleteCollection(collectionName: string): Promise<DeleteDocumentResult>;
    startTransaction(): Promise<Transaction>;
    runTransaction<T = any>(scope: (transaction: Transaction) => Promise<T>): Promise<T>;
}
