import type { AddManyDocumentParam, AddOneDocumentParam, QueryChainCommand } from '@alipay/faas-db-builder';
import { Sort, UpdateData } from '@alipay/faas-db-builder';
import { CountDocumentResult, Document, Query, Httpclient, UpdateDocumentResult, DeleteDocumentResult, UpdateAndReturnDocumentResult } from '@alipay/faas-common-sdk';
import { AddManyDocumentsResult, AddOneDocumentResult, DatabaseCloudConfig } from '../types';
export declare class Collection {
    #private;
    constructor(config: DatabaseCloudConfig, collectionName: string, httpclient: Httpclient);
    add(param: AddManyDocumentParam): Promise<AddManyDocumentsResult>;
    add(param: AddOneDocumentParam): Promise<AddOneDocumentResult>;
    doc(_id: string): Document;
    limit(limit: number): Query;
    skip(skip: number): Query;
    where(match: QueryChainCommand): Query;
    projection(projection: object): Query;
    field(projection: object): Query;
    orderBy(field: string, sort: Sort): Query;
    aggregate(): import("@alipay/faas-common-sdk").Aggregate;
    update(data: UpdateData): Promise<UpdateDocumentResult>;
    updateAndReturn<T = any>(data: UpdateData): Promise<UpdateAndReturnDocumentResult<T>>;
    set(data: UpdateData): Promise<UpdateDocumentResult>;
    remove(): Promise<DeleteDocumentResult>;
    get<T = any>(): Promise<Array<T>>;
    count(): Promise<CountDocumentResult>;
}
