import { AlipayContext } from '@alipay/faas-server-utils';
import { CallFunctionResult, DeleteFileParam, DeleteFileResult, DownloadFileParam, GetTempFileURLParam, GetTempFileURLResult, GetUploadFileURLParam, GetUploadFileURLResult } from '@alipay/faas-common-sdk';
import { Database } from './Database';
import { MySQL } from './MySQL';
import { Redis, RedisOptions } from './Redis';
import { Storage } from './Storage';
import type { OpenapiFunction, OpenapiCaller } from './Openapi';
import type { CallFunctionParam, CloudInitOptions, DownloadFileResult, GetDatabaseOptions, UploadFileParam, UploadFileResult } from './types';
import { WebsocketSDK } from './Websocket';
export declare function initRuntimeEnv(env: Record<string, string>): void;
export declare class Cloud {
    #private;
    constructor();
    refreshConfig(): void;
    init(config?: CloudInitOptions): void;
    getAlipayContext(): AlipayContext;
    callFunction<T = any>(param: CallFunctionParam): Promise<CallFunctionResult<T>>;
    database(config?: GetDatabaseOptions): Database;
    mysql(): MySQL;
    redis(options?: RedisOptions | string): Redis;
    get openapi(): OpenapiFunction;
    ws(): WebsocketSDK;
    getOpenapiCaller(): OpenapiCaller;
    getStorage(): Storage;
    getUploadFileURL(cloudPath: string | GetUploadFileURLParam): Promise<GetUploadFileURLResult>;
    uploadFile(param: UploadFileParam): Promise<UploadFileResult>;
    downloadFile(param: DownloadFileParam): Promise<DownloadFileResult>;
    deleteFile(param: DeleteFileParam): Promise<DeleteFileResult>;
    getTempFileURL(param: GetTempFileURLParam): Promise<GetTempFileURLResult>;
}
