import { Command } from '../command';
import type { MongoCollectionListQueryOperation, MongoCollectionOperation, RegExpParam } from '../typing';
import { CollectionBuilder } from './Collection';
import { Geo } from './Geo';
import { Regex } from './Regex';
export declare class MongoBuilder {
    command: Command;
    Geo: Geo;
    constructor();
    RegExp(param: RegExpParam): Regex;
    regexp(param: RegExpParam): Regex;
    collection(collectionName: string): CollectionBuilder;
    createCollection(collectionName: string): MongoCollectionOperation;
    getCollection(collectionName: string): MongoCollectionOperation;
    listCollection(limit?: number, skip?: number): MongoCollectionListQueryOperation;
    deleteCollection(collectionName: string): MongoCollectionOperation;
}
