import type { QueryChainCommand } from '../command/AbstractCommand';
import { Sort } from '../common/constant';
import type { AddDocumentParam, AddManyDocumentParam, CollectionBuilderOptions, MongoDocumentOperation } from '../typing';
import { AggregateBuilder } from './Aggregate';
import { DocumentBuilder } from './Document';
import { QueryBuilder } from './Query';
export declare class CollectionBuilder {
    private readonly collectionName;
    private readonly options;
    constructor(collectionName: string, options?: Partial<CollectionBuilderOptions>);
    add(param: AddDocumentParam): MongoDocumentOperation;
    batchAdd(param: AddManyDocumentParam): MongoDocumentOperation;
    doc(_id: string): DocumentBuilder;
    limit(limit: number): QueryBuilder;
    skip(skip: number): QueryBuilder;
    where(match: QueryChainCommand): QueryBuilder;
    projection(projection: object): QueryBuilder;
    orderBy(field: string, sort: Sort): QueryBuilder;
    aggregate(): AggregateBuilder;
    get(): MongoDocumentOperation;
    count(): MongoDocumentOperation;
}
