import { LogicQueryCommand, QueryCommand } from '../AbstractCommand';
export declare abstract class LogicQueryCommandImpl extends LogicQueryCommand {
    protected readonly commands: Array<object | QueryCommand>;
    protected abstract readonly name: string;
    constructor(commands: Array<object | QueryCommand>);
    protected get op(): string;
    pushCommand(cmd: QueryCommand): void;
    stringifyWithKey(key: string): {
        [x: string]: any[];
    };
    stringify(): any;
}
export declare class AndCommand extends LogicQueryCommandImpl {
    protected readonly name = "and";
}
export declare class OrCommand extends LogicQueryCommandImpl {
    protected readonly name = "or";
}
export declare class NorCommand extends LogicQueryCommandImpl {
    protected readonly name = "nor";
}
export declare class NotCommand extends LogicQueryCommand {
    private readonly command;
    constructor(command: object | QueryCommand);
    stringifyWithKey(key: string): any;
    stringify(): any;
}
