import { Sort } from '../common/constant';
import { AggregateArrayExpression, AggregateDateExpression, AggregateDateParam, AggregateDocumentExpression, AggregateExpression, AggregateExpressionPair, AggregateExpressionRecord, AggregateNumberExpression, AggregateNumberExpressionPair, AggregateStringExpression, AggregateStringExpressionPair, CondCommandParam, DateToStringCommandParam, IndexOfArrayCommandParam, LetCommandParam, MapParam, PushCommandParam, SliceCommandParam, SubstrBytesCommandParam, SubstrCommandParam, SubtractCommandParam, SwitchCommandParam, GeoWinthinParam, GeoNearParam, GeoIntersectsParam, AggregateRangeParam, AggregateFilterParam, AggregateReduceParam, AggregateZipParam, AggregateDateFromStringParam, AggregateStrcasecmpParam, AggregateSubstrCPParam, AggregateIndexOfParam, AggregateArrayExpressionPair, AggregatedateFromPartsParam, AggregateLiteralParam } from '../typing';
import { AggregateCommand, QueryChainCommand, QueryCommand } from './AbstractCommand';
import { AbsAggregateCommand, AddAggregateCommand, AddToSetAggregateCommand, AllElementsTrueAggregateCommand, AndAggregateCommand, AnyElementTrueAggregateCommand, ArrayElemAtAggregateCommand, ArrayToObjectAggregateCommand, AvgAggregateCommand, CeilAggregateCommand, CMPAggregateCommand, ConcatAggregateCommand, ConcatArraysAggregateCommand, CondAggregateCommand, CountAggregateCommand, DateFromStringAggregateCommand, DateToStringAggregateCommand, DivideAggregateCommand, EqAggregateCommand, ExpAggregateCommand, FilterAggregateCommand, FirstAggregateCommand, FloorAggregateCommand, GtAggregateCommand, GteAggregateCommand, IfNullAggregateCommand, InAggregateCommand, IndexOfArrayAggregateCommand, IndexOfBytesAggregateCommand, IndexOfCPAggregateCommand, IsArrayAggregateCommand, ISOWeekAggregateCommand, LastAggregateCommand, LetAggregateCommand, LiteralAggregateCommand, LnAggregateCommand, Log10AggregateCommand, LogAggregateCommand, LtAggregateCommand, LteAggregateCommand, MapAggregateCommand, MaxAggregateCommand, MergeObjectsAggregateCommand, MinAggregateCommand, ModAggregateCommand, MonthAggregateCommand, MultiplyAggregateCommand, NeqAggregateCommand, NotAggregateCommand, ObjectToArrayAggregateCommand, OrAggregateCommand, PowAggregateCommand, PushAggregateCommand, RangeAggregateCommand, ReverseArrayAggregateCommand, ReduceAggregateCommand, SetDifferenceAggregateCommand, SetEqualsAggregateCommand, SetIntersectionAggregateCommand, SetIsSubsetAggregateCommand, SetUnionAggregateCommand, SizeAggregateCommand, SliceAggregateCommand, SplitAggregateCommand, SqrtAggregateCommand, StdDevPopAggregateCommand, StdDevSampAggregateCommand, StrcasecmpAggregateCommand, StrLenBytesAggregateCommand, StrLenCPAggregateCommand, SubstrAggregateCommand, SubstrBytesAggregateCommand, SubstrCPAggregateCommand, SubtractAggregateCommand, SumAggregateCommand, SwitchAggregateCommand, ToLowerAggregateCommand, ToUpperAggregateCommand, TruncAggregateCommand, WeekAggregateCommand, YearAggregateCommand, ZipAggregateCommand, DateFromPartsAggregateCommand, DayOfMonthAggregateCommand, DayOfWeekAggregateCommand, DayOfYearAggregateCommand, HourAggregateCommand, ISODayOfWeekAggregateCommand, ISOWeekYearAggregateCommand, MillisecondAggregateCommand, MinuteAggregateCommand, SecondAggregateCommand } from './aggregate';
import { AggregatePipeline } from './AggregatePipeline';
import { ExprCommand } from './query/expr';
import { QueryChain } from './query/QueryChain';
import { AddToSetCommand } from './update/addToSet';
import { IncCommand } from './update/inc';
import { MaxCommand } from './update/max';
import { MinCommand } from './update/min';
import { MulCommand } from './update/mul';
import { PopCommand } from './update/pop';
import { PullCommand } from './update/pull';
import { PullAllCommand } from './update/pullAll';
import { PushCommand } from './update/push';
import { RemoveCommand } from './update/remove';
import { RenameCommand } from './update/rename';
import { SetCommand } from './update/set';
import { GeoIntersectsCommand, GeoNearCommand, GeoWithinCommand } from './query/geo';
import { UnShiftCommand } from './update/unshift';
import { ShiftCommand } from './update/shift';
export declare class AggregateCommandFactory {
    pipeline(): AggregatePipeline;
    avg(val: AggregateExpression | AggregateExpression[]): AvgAggregateCommand;
    count(): CountAggregateCommand;
    max(val: AggregateExpression | AggregateExpression[]): MaxAggregateCommand;
    min(val: AggregateExpression | AggregateExpression[]): MinAggregateCommand;
    sum(val: AggregateExpression | AggregateExpression[]): SumAggregateCommand;
    and(cmd: Array<AggregateExpression>): AndAggregateCommand;
    and(...cmd: Array<AggregateExpression>): AndAggregateCommand;
    or(cmd: Array<AggregateExpression>): OrAggregateCommand;
    or(...cmd: Array<AggregateExpression>): OrAggregateCommand;
    not(cmd: AggregateExpression): NotAggregateCommand;
    cmp(values: AggregateExpressionPair): CMPAggregateCommand;
    cmp(values: AggregateExpression, other: AggregateExpression): CMPAggregateCommand;
    eq(values: AggregateExpressionPair): EqAggregateCommand;
    eq(values: AggregateExpression, other: AggregateExpression): EqAggregateCommand;
    neq(values: AggregateExpressionPair): NeqAggregateCommand;
    neq(values: AggregateExpression, other: AggregateExpression): NeqAggregateCommand;
    lt(values: AggregateExpressionPair): LtAggregateCommand;
    lt(values: AggregateExpression, other: AggregateExpression): LtAggregateCommand;
    lte(values: AggregateExpressionPair): LteAggregateCommand;
    lte(values: AggregateExpression, other: AggregateExpression): LteAggregateCommand;
    gt(values: AggregateExpressionPair): GtAggregateCommand;
    gt(values: AggregateExpression, other: AggregateExpression): GtAggregateCommand;
    gte(values: AggregateExpressionPair): GteAggregateCommand;
    gte(values: AggregateExpression, other: AggregateExpression): GteAggregateCommand;
    addToSet(value: AggregateExpression): AddToSetAggregateCommand;
    arrayElemAt(array: [AggregateArrayExpression, AggregateNumberExpression]): ArrayElemAtAggregateCommand;
    arrayElemAt(array: AggregateArrayExpression, idx: AggregateNumberExpression): ArrayElemAtAggregateCommand;
    indexOfArray(array: IndexOfArrayCommandParam): IndexOfArrayAggregateCommand;
    indexOfArray(array: AggregateArrayExpression, value: AggregateExpression): IndexOfArrayAggregateCommand;
    indexOfArray(array: AggregateArrayExpression, value: AggregateExpression, start: number): IndexOfArrayAggregateCommand;
    indexOfArray(array: AggregateArrayExpression, value: AggregateExpression, start: number, end: number): IndexOfArrayAggregateCommand;
    isArray(value: AggregateExpression): IsArrayAggregateCommand;
    size(value: AggregateArrayExpression): SizeAggregateCommand;
    in(target: AggregateExpression, key: AggregateArrayExpression): InAggregateCommand;
    in(target: [AggregateExpression, AggregateArrayExpression]): InAggregateCommand;
    slice(cond: SliceCommandParam): SliceAggregateCommand;
    slice(cond: AggregateArrayExpression, n: AggregateNumberExpression): SliceAggregateCommand;
    slice(cond: AggregateArrayExpression, position: AggregateNumberExpression, n: AggregateNumberExpression): SliceAggregateCommand;
    map(param: MapParam): MapAggregateCommand;
    ifNull(value: AggregateExpressionPair): IfNullAggregateCommand;
    ifNull(value: AggregateExpression, replacement: AggregateExpression): IfNullAggregateCommand;
    cond(value: CondCommandParam): CondAggregateCommand;
    switch(value: SwitchCommandParam): SwitchAggregateCommand;
    concat(...str: AggregateStringExpression[]): ConcatAggregateCommand;
    concat(str: AggregateStringExpression[]): ConcatAggregateCommand;
    dateToString(value: DateToStringCommandParam): DateToStringAggregateCommand;
    toLower(value: AggregateStringExpression): ToLowerAggregateCommand;
    toUpper(value: AggregateStringExpression): ToUpperAggregateCommand;
    split(value: AggregateStringExpressionPair): SplitAggregateCommand;
    split(value: AggregateStringExpression, splitter: AggregateStringExpression): SplitAggregateCommand;
    substr(value: SubstrCommandParam): SubstrAggregateCommand;
    substr(value: AggregateStringExpression, start: AggregateNumberExpression, length: AggregateNumberExpression): SubstrAggregateCommand;
    substrBytes(value: SubstrBytesCommandParam): SubstrBytesAggregateCommand;
    substrBytes(value: AggregateStringExpression, start: AggregateNumberExpression, length: AggregateNumberExpression): SubstrBytesAggregateCommand;
    first(value: AggregateExpression): FirstAggregateCommand;
    last(value: AggregateExpression): LastAggregateCommand;
    push(value: AggregateExpression | AggregateExpressionRecord): PushAggregateCommand;
    let(value: LetCommandParam): LetAggregateCommand;
    add(val: AggregateNumberExpression[]): AddAggregateCommand;
    add(...val: AggregateNumberExpression[]): AddAggregateCommand;
    subtract(num1: SubtractCommandParam): SubtractAggregateCommand;
    subtract(num1: AggregateDateExpression, num2: AggregateNumberExpression): SubtractAggregateCommand;
    multiply(val: AggregateNumberExpression[]): MultiplyAggregateCommand;
    multiply(...val: AggregateNumberExpression[]): MultiplyAggregateCommand;
    divide(val: AggregateNumberExpressionPair): DivideAggregateCommand;
    divide(num1: AggregateNumberExpression, num2: AggregateNumberExpression): DivideAggregateCommand;
    abs(value: AggregateNumberExpression): AbsAggregateCommand;
    ceil(value: AggregateNumberExpression): CeilAggregateCommand;
    exp(value: AggregateNumberExpression): ExpAggregateCommand;
    floor(value: AggregateNumberExpression): FloorAggregateCommand;
    ln(value: AggregateNumberExpression): LnAggregateCommand;
    log(val: AggregateNumberExpressionPair): LogAggregateCommand;
    log(num1: AggregateNumberExpression, num2: AggregateNumberExpression): LogAggregateCommand;
    log10(value: AggregateNumberExpression): Log10AggregateCommand;
    mod(val: AggregateNumberExpressionPair): ModAggregateCommand;
    mod(num1: AggregateNumberExpression, num2: AggregateNumberExpression): ModAggregateCommand;
    pow(val: AggregateNumberExpressionPair): PowAggregateCommand;
    pow(num1: AggregateNumberExpression, num2: AggregateNumberExpression): PowAggregateCommand;
    sqrt(val: AggregateNumberExpression): SqrtAggregateCommand;
    trunc(value: AggregateNumberExpression | AggregateNumberExpressionPair): TruncAggregateCommand;
    mergeObjects(value: AggregateDocumentExpression | AggregateDocumentExpression[]): MergeObjectsAggregateCommand;
    month(value: AggregateDateParam): MonthAggregateCommand;
    year(value: AggregateDateParam): YearAggregateCommand;
    week(value: AggregateDateParam): WeekAggregateCommand;
    isoWeek(value: AggregateDateParam): ISOWeekAggregateCommand;
    arrayToObject(value: AggregateArrayExpression[]): ArrayToObjectAggregateCommand;
    concatArrays(value: AggregateArrayExpression[]): ConcatArraysAggregateCommand;
    filter(value: AggregateFilterParam): FilterAggregateCommand;
    objectToArray(value: AggregateDocumentExpression): ObjectToArrayAggregateCommand;
    range(val: AggregateRangeParam): RangeAggregateCommand;
    range(start: AggregateNumberExpression, end: AggregateNumberExpression, nonZeroStep?: AggregateNumberExpression): RangeAggregateCommand;
    reduce(value: AggregateReduceParam): ReduceAggregateCommand;
    reverseArray(value: AggregateArrayExpression): ReverseArrayAggregateCommand;
    zip(value: AggregateZipParam): ZipAggregateCommand;
    dateFromString(value: AggregateDateFromStringParam): DateFromStringAggregateCommand;
    indexOfBytes(value: AggregateIndexOfParam): IndexOfBytesAggregateCommand;
    indexOfCP(value: AggregateIndexOfParam): IndexOfCPAggregateCommand;
    strLenBytes(value: AggregateStringExpression): StrLenBytesAggregateCommand;
    strLenCP(value: AggregateStringExpression): StrLenCPAggregateCommand;
    strcasecmp(value: AggregateStrcasecmpParam): StrcasecmpAggregateCommand;
    substrCP(value: AggregateSubstrCPParam): SubstrCPAggregateCommand;
    stdDevPop(value: AggregateExpression): StdDevPopAggregateCommand;
    stdDevSamp(value: AggregateExpression): StdDevSampAggregateCommand;
    allElementsTrue(value: AggregateArrayExpression[]): AllElementsTrueAggregateCommand;
    anyElementTrue(value: AggregateArrayExpression[]): AnyElementTrueAggregateCommand;
    setDifference(value: AggregateArrayExpressionPair): SetDifferenceAggregateCommand;
    setEquals(value: AggregateArrayExpressionPair): SetEqualsAggregateCommand;
    setIntersection(value: AggregateArrayExpressionPair): SetIntersectionAggregateCommand;
    setIsSubset(value: AggregateArrayExpressionPair): SetIsSubsetAggregateCommand;
    setUnion(value: AggregateArrayExpressionPair): SetUnionAggregateCommand;
    literal(value: AggregateLiteralParam): LiteralAggregateCommand;
    dateFromParts(value: AggregatedateFromPartsParam): DateFromPartsAggregateCommand;
    dayOfMonth(value: AggregateDateParam): DayOfMonthAggregateCommand;
    dayOfWeek(value: AggregateDateParam): DayOfWeekAggregateCommand;
    dayOfYear(value: AggregateDateParam): DayOfYearAggregateCommand;
    hour(value: AggregateDateParam): HourAggregateCommand;
    isoDayOfWeek(value: AggregateDateParam): ISODayOfWeekAggregateCommand;
    isoWeekYear(value: AggregateDateParam): ISOWeekYearAggregateCommand;
    millisecond(value: AggregateDateParam): MillisecondAggregateCommand;
    minute(value: AggregateDateParam): MinuteAggregateCommand;
    second(value: AggregateDateParam): SecondAggregateCommand;
}
export declare class Command {
    aggregate: AggregateCommandFactory;
    Sort: typeof Sort;
    constructor();
    addToSet(value: any): AddToSetCommand;
    inc(num: number): IncCommand;
    max(max: any): MaxCommand;
    min(min: any): MinCommand;
    mul(num: number): MulCommand;
    pop(value?: 1 | -1): PopCommand;
    pull(value: any | QueryChainCommand): PullCommand;
    pullAll(values: any[]): PullAllCommand;
    push(value: PushCommandParam | any[] | any, ...args: any[]): PushCommand;
    remove(): RemoveCommand;
    rename(name: string): RenameCommand;
    set(data: object): SetCommand;
    expr(cmd: AggregateCommand): ExprCommand;
    geoWithin(val: GeoWinthinParam): GeoWithinCommand;
    geoNear(val: GeoNearParam): GeoNearCommand;
    geoIntersects(val: GeoIntersectsParam): GeoIntersectsCommand;
    unshift(val: any | any[]): UnShiftCommand;
    shift(): ShiftCommand;
    and(cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    and(...cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    or(cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    or(...cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    not(cmd: QueryCommand | QueryChain): QueryChain;
    nor(cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    nor(...cmd: Array<object | QueryCommand | QueryChain>): QueryChain;
    eq(val: any): QueryChain;
    neq(val: any): QueryChain;
    lt(val: any): QueryChain;
    lte(val: any): QueryChain;
    gt(val: any): QueryChain;
    gte(val: any): QueryChain;
    in(val: any[]): QueryChain;
    nin(val: any[]): QueryChain;
    exists(exists: boolean): QueryChain;
    mod(divisor: number, remainder: number): QueryChain;
    all(val: any[]): QueryChain;
    elemMatch(cmd: object | QueryChain | QueryCommand): QueryChain;
    size(size: number): QueryChain;
}
