import { Sort } from '../common/constant';
import type { AggregateGeoNearParam, bucketAutoParam, bucketParam, LookupAggregateParam, ReplaceRootParam, SampleAggregateParam, UnwindParam } from '../typing';
import type { AggregateCommand, QueryChainCommand } from './AbstractCommand';
export declare class AggregatePipeline {
    private readonly pipeline;
    constructor();
    addFields(fields: Record<string, any | AggregateCommand>): this;
    count(field: string): this;
    match(match: QueryChainCommand): this;
    group(group: object): this;
    project(project: Record<string, string | boolean | 0 | 1 | object | AggregateCommand>): this;
    replaceRoot(root: ReplaceRootParam): this;
    sample(sample: SampleAggregateParam): this;
    lookup(lookup: LookupAggregateParam): this;
    sort(sort: Record<string, Sort | 1 | -1>): this;
    limit(limit: number): this;
    skip(skip: number): this;
    unwind(unwind: string | UnwindParam): this;
    geoNear(near: AggregateGeoNearParam): this;
    bucket(bucket: bucketParam): this;
    bucketAuto(bucketAuto: bucketAutoParam): this;
    sortByCount(sortByCount: string | object): this;
    done(): ({
        $geoNear: any;
        $match?: undefined;
        $sort?: undefined;
    } | {
        $match: any;
        $geoNear?: undefined;
        $sort?: undefined;
    } | {
        [x: string]: any;
        $geoNear?: undefined;
        $match?: undefined;
        $sort?: undefined;
    } | {
        $sort: {};
        $geoNear?: undefined;
        $match?: undefined;
    })[];
    private pushStage;
}
