export declare abstract class AbstractCommand {
    abstract stringify(): any;
}
export declare abstract class UpdateCommand extends AbstractCommand {
    abstract get operator(): string;
}
export declare abstract class QueryUpdateCommand extends UpdateCommand {
    abstract stringifyWithKey(key: string): any;
}
export declare abstract class UpdateArrayCommand extends UpdateCommand {
}
export declare abstract class QueryUpdateArrayCommand extends QueryUpdateCommand {
}
export declare abstract class QueryCommand extends AbstractCommand {
}
export declare abstract class LogicQueryCommand extends QueryCommand {
    abstract stringifyWithKey(key: string): any;
}
export declare abstract class GeoCommand extends QueryCommand {
}
export declare abstract class EvaluationQueryCommand extends QueryCommand {
}
export declare abstract class AggregateCommand extends AbstractCommand {
    protected readonly name: string;
    protected readonly value: any;
    protected constructor(name: string, value: any);
    stringify(): any;
}
export type UnchainCommand<T> = T extends CommandChain ? never : T;
export type QueryChainCommand = object | QueryCommand | CommandChain;
export declare abstract class CommandChain {
    lastCmd: QueryCommand;
    constructor(cmd: QueryCommand);
    static unchain<T = QueryChainCommand>(cmd: T): UnchainCommand<T>;
}
