import { AggregateCommand, QueryCommand, UpdateCommand } from './command/AbstractCommand';
import { CollectionAction, DocumentAction, PipelineStageName, Sort, Target } from './common/constant';
import { GeoPolygon, GeoMultiPolygon, GeoPoint, GeoLineString, GeoMultiPoint, GeoMultiLineString } from './mongo-builder/Geo';
export type BuiltInType = 'string' | 'number' | 'bigint' | 'boolean' | 'symbol' | 'undefined' | 'object' | 'function';
export type AggregateExpression<T = any> = string | AggregateCommand | T;
export type AggregateExpressionPair = [AggregateExpression, AggregateExpression];
export type AggregateArrayExpression = AggregateExpression<any[]>;
export type AggregateArrayExpressionPair = [AggregateArrayExpression, AggregateArrayExpression];
export type AggregateNumberExpression = AggregateExpression<number>;
export type AggregateNumberExpressionPair = [AggregateNumberExpression, AggregateNumberExpression];
export type AggregateStringExpression = string | AggregateCommand;
export type AggregateStringExpressionPair = [AggregateStringExpression, AggregateStringExpression];
export type AggregateBooleanExpression = AggregateExpression<boolean>;
export type AggregateDateExpression = AggregateExpression<Date | number>;
export type AggregateDocumentExpression = AggregateExpression<object>;
export type AggregateExpressionRecord = Record<string, AggregateExpression>;
export interface CollectionBuilderOptions {
    maxAddCount: number;
}
export interface SortOption {
    field: string;
    sort: Sort;
}
export interface UpdateData {
    data: object;
}
export interface DocumentData {
    _id?: string;
    [key: string]: any;
}
export interface AddOneDocumentParam {
    data: DocumentData;
}
export interface AddManyDocumentParam {
    ordered?: boolean;
    data: DocumentData[];
}
export type AddDocumentParam = AddOneDocumentParam | AddManyDocumentParam;
export interface BaseOptions {
    $match?: object;
    $limit?: number;
}
export interface FindOptions extends BaseOptions {
    $project: object;
    $sort: Record<string, 1 | -1>;
    $skip?: number;
}
export interface MongoCollectionListQueryOperation {
    target: Target.collection;
    action: CollectionAction.queryList;
    options: Record<string, unknown>;
}
export interface MongoCollectionOperation {
    target: Target.collection;
    action: Omit<CollectionAction, CollectionAction.queryList>;
    collectionName: string;
}
export interface MongoDocumentOperation {
    target: Target.document;
    action: DocumentAction;
    collectionName: string;
    options: Record<string, unknown>;
}
export type MongoOperation = MongoDocumentOperation | MongoCollectionOperation | MongoCollectionListQueryOperation;
export interface PipelineStage {
    name: PipelineStageName;
    param: any;
}
export interface SampleAggregateParam {
    size: number;
}
export interface EqualityMatchLookupParam {
    from: string;
    localField: string;
    foreignField: string;
    as: string;
}
export interface JoinLookupParam {
    from: string;
    let: Record<string, string | object | AggregateCommand | QueryCommand | UpdateCommand | any | any[]>;
    pipeline: object[];
    as: string;
}
export type LookupAggregateParam = EqualityMatchLookupParam | JoinLookupParam;
export interface PushCommandParam {
    each: any[];
    position?: number;
    sort?: 1 | -1 | Sort;
    slice?: number;
}
export type IndexOfArrayCommandParam = [AggregateArrayExpression, AggregateExpression, number?, number?];
export interface DateToStringCommandParam {
    date: AggregateDateExpression;
    format?: string;
    timezone?: string;
    onNull?: string;
}
export type SliceCommandParam = [AggregateArrayExpression, AggregateNumberExpression, AggregateNumberExpression?];
export interface CondCommandObjectParam {
    if: AggregateBooleanExpression;
    then: any;
    else: any;
}
export type CondCommandArrayParam = [AggregateBooleanExpression, any, any];
export type CondCommandParam = CondCommandObjectParam | CondCommandArrayParam;
export interface SwitchCommandBranch {
    case: AggregateBooleanExpression;
    then: AggregateExpression;
}
export interface SwitchCommandParam {
    branches: Array<SwitchCommandBranch | [AggregateBooleanExpression, AggregateExpression]>;
    default?: AggregateExpression;
}
export interface LetCommandParam {
    vars: Record<string, AggregateExpression>;
    in: AggregateExpression;
}
export interface ReplaceRootParam {
    newRoot: string | Record<string, string | AggregateCommand>;
}
export interface UnwindParam {
    path: string;
    includeArrayIndex?: string;
    preserveNullAndEmptyArrays?: boolean;
}
export interface RegExpParam {
    regexp: string;
    options?: string;
}
export interface MapParam {
    input: AggregateExpression;
    as?: string;
    in: AggregateExpression;
}
export interface AggregateDateWithTimezone {
    date: AggregateDateExpression;
    timezone?: string;
}
export type AggregateDateParam = AggregateDateExpression | AggregateDateWithTimezone;
export type SubstrCommandParam = [AggregateStringExpression, AggregateNumberExpression, AggregateNumberExpression];
export type SubstrBytesCommandParam = SubstrCommandParam;
export type SubtractCommandParam = [AggregateDateExpression, AggregateNumberExpression];
export interface GeoWinthinParam {
    centerSphere?: [[number, number], number];
    geometry?: GeoPolygon | GeoMultiPolygon;
}
export interface GeoNearParam {
    geometry: GeoPoint;
    maxDistance?: number;
    minDistance?: number;
}
export interface GeoIntersectsParam {
    geometry: GeoPoint | GeoLineString | GeoPolygon | GeoMultiPoint | GeoMultiLineString | GeoMultiPolygon;
}
export interface AggregateGeoNearParam {
    near: GeoPoint;
    spherical?: boolean;
    maxDistance?: number;
    minDistance?: number;
    query?: object;
    distanceMultiplier?: number;
    distanceField: string;
    includeLocs?: string;
    key?: string;
}
export interface bucketParam {
    groupBy: AggregateExpression;
    boundaries: Array<number>;
    default?: string;
    output?: object;
}
export interface bucketAutoParam {
    groupBy: AggregateExpression;
    buckets: number;
    granularity?: string;
    output?: object;
}
export interface AggregateFilterParam {
    input: AggregateArrayExpression;
    cond: AggregateBooleanExpression;
    as?: string;
}
export interface AggregateReduceParam {
    input: AggregateArrayExpression;
    initialValue: AggregateExpression;
    in: AggregateExpression;
}
export type AggregateRangeParam = [AggregateNumberExpression, AggregateNumberExpression, AggregateNumberExpression?];
export interface AggregateZipParam {
    inputs: AggregateArrayExpression[];
    useLongestLength?: boolean;
    defaults?: any[];
}
export interface AggregateDateFromStringParam {
    dateString: string;
    format?: string;
    timezone?: string;
    onError?: AggregateExpression;
    onNull?: AggregateExpression;
}
export type AggregateIndexOfParam = [AggregateStringExpression, AggregateStringExpression, AggregateNumberExpression?, AggregateNumberExpression?];
export type AggregateStrcasecmpParam = [AggregateStringExpression, AggregateStringExpression];
export type AggregateSubstrCPParam = [AggregateStringExpression, AggregateNumberExpression, AggregateNumberExpression];
export interface AggregatedateFromPartsParam {
    year?: AggregateNumberExpression;
    month?: AggregateNumberExpression;
    day?: AggregateNumberExpression;
    hour?: AggregateNumberExpression;
    minute?: AggregateNumberExpression;
    second?: AggregateNumberExpression;
    millisecond?: AggregateNumberExpression;
    timezone?: string;
    isoWeekYear?: AggregateNumberExpression;
    isoWeek?: AggregateNumberExpression;
    isoDayOfWeek?: AggregateNumberExpression;
}
export type AggregateLiteralParam = AggregateExpression | QueryCommand | UpdateCommand;
