import type { QueryChainCommand } from '../command/AbstractCommand';
import { Sort } from '../common/constant';
import type { MongoDocumentOperation, UpdateData } from '../typing';
export declare class QueryBuilder {
    private readonly criteria;
    private readonly collectionName;
    constructor(collectionName: string);
    limit(limit: number): QueryBuilder;
    skip(skip: number): QueryBuilder;
    where(match: QueryChainCommand): QueryBuilder;
    projection(projection: object): QueryBuilder;
    orderBy(field: string, sort: Sort | string): QueryBuilder;
    update(data: UpdateData): MongoDocumentOperation;
    updateAndReturn(data: UpdateData): MongoDocumentOperation;
    set(data: UpdateData): MongoDocumentOperation;
    remove(): MongoDocumentOperation;
    get(): MongoDocumentOperation;
    count(): MongoDocumentOperation;
    private baseOptions;
    private findOptions;
    private build;
}
