export declare abstract class Geometry<TCoordinates> {
    readonly type: string;
    readonly coordinates: Readonly<TCoordinates>;
    constructor(type: string, coordinates: TCoordinates);
    toJSON(): object;
}
export declare class GeoPoint extends Geometry<Readonly<[number, number]>> {
    longitude: number;
    latitude: number;
    constructor(longitude: number, latitude: number);
}
export declare class GeoLineString extends Geometry<Readonly<[number, number][]>> {
    points: GeoPoint[];
    constructor(points: GeoPoint[]);
}
export declare class GeoPolygon extends Geometry<Readonly<[number, number][][]>> {
    lines: GeoLineString[];
    constructor(lines: GeoLineString[]);
}
export declare class GeoMultiPoint extends Geometry<Readonly<[number, number][]>> {
    points: GeoPoint[];
    constructor(points: GeoPoint[]);
}
export declare class GeoMultiLineString extends Geometry<Readonly<[number, number][][]>> {
    lines: GeoLineString[];
    constructor(lines: GeoLineString[]);
}
export declare class GeoMultiPolygon extends Geometry<Readonly<[number, number][][][]>> {
    polygons: GeoPolygon[];
    constructor(polygons: GeoPolygon[]);
}
export declare class Geo {
    Point(longitude: number, latitude: number): GeoPoint;
    LineString(points: GeoPoint[]): GeoLineString;
    Polygon(lineStrings: GeoLineString[]): GeoPolygon;
    MultiPoint(points: GeoPoint[]): GeoMultiPoint;
    MultiLineString(lineStrings: GeoLineString[]): GeoMultiLineString;
    MultiPolygon(polygons: GeoPolygon[]): GeoMultiPolygon;
}
