export declare enum ErrorCode {
    INVALID_PARAM = "INVALID_PARAM",
    INVALID_COMMAND = "INVALID_COMMAND",
    SEMANTIC_ERROR = "SEMANTIC_ERROR"
}
export declare class DbBuildError extends Error {
    code: ErrorCode;
    constructor(message: string);
    static create(code: ErrorCode, message: string): DbBuildError;
    static invalidParam(paramName: string, message: string): DbBuildError;
    static invalidCommand(message: string): DbBuildError;
    static semanticError(message: string): DbBuildError;
}
