import { DocumentData, UpdateData } from '@alipay/faas-db-builder';
export interface CallbackParam<T, V = Error> {
    success?: (res: T) => any;
    fail?: (e: V) => any;
    complete?: (e: T | V) => any;
}
export interface FunctionCall<Param, Result, E = Error> {
    (param: Param): Promise<Result>;
    (param: Param & CallbackParam<Result, E>): void;
}
export interface CallFunctionFailResponse {
    errCode: number;
    errMsg: string;
    errDetail?: string;
}
export interface CommonCallResponse<T = object> {
    code: number;
    message: string;
    data: T;
}
export type HttpMethod = 'GET' | 'HEAD' | 'POST' | 'PUT' | 'DELETE' | 'CONNECT' | 'OPTIONS' | 'TRACE' | 'PATCH';
export type ResponseDataType = 'text' | 'json' | 'arrayBuffer' | 'blob' | 'formData' | 'readableStream';
export interface HttpRequestOptions {
    method: HttpMethod;
    path: string;
    data?: any;
    headers?: Record<string, string>;
    responseDataType?: ResponseDataType;
    timeout?: number;
}
export interface HttpResponse<T> {
    status: number;
    requestID: string;
    headers: Record<string, string>;
    data: T;
}
export interface Httpclient {
    request<T>(options: HttpRequestOptions): Promise<HttpResponse<T>>;
}
export interface CreateOptions {
    httpclient: Httpclient;
    type: 'web' | 'miniprogram' | 'function';
}
export interface CreateDatabaseOptions extends CreateOptions {
    databaseName?: string;
    throwOnNotFound?: boolean;
}
export interface CallFunctionResult<T = any> {
    requestID: string;
    result?: T;
    headers: Record<string, string>;
}
export interface CallFunctionParam {
    name: string;
    async?: boolean;
    data?: object | string | number | boolean;
    resultDataType?: ResponseDataType;
    headers?: Record<string, string>;
    timeout?: number;
}
export type CallFunction<T> = FunctionCall<CallFunctionParam, CallFunctionResult<T>>;
export interface CallContainerResult<T> {
    data: T;
    statusCode: number;
    header: Record<string, string | string[]>;
}
export interface CallContainerParam {
    path: string;
    method?: string;
    header?: Record<string, string | string[]>;
    data?: string | object;
    timeout?: number;
    dataType?: 'json' | 'text';
}
export type CallContainer<T> = FunctionCall<CallContainerParam, CallContainerResult<T>>;
export interface AddDocumentParam {
    data: DocumentData;
}
export interface AddDocumentResult {
    _id: string;
}
export type AddDocumentParamWithCallback = AddDocumentParam & CallbackParam<AddDocumentResult>;
export interface CountDocumentResult {
    total: number;
}
export interface DeleteDocumentResult {
    count: number;
}
export interface UpdateDocumentResult {
    count: number;
}
export interface UpdateAndReturnDocumentResult<T = any> {
    updated: 0 | 1;
    doc: T;
}
export type UpdateDataParamWithCallback = UpdateData & CallbackParam<UpdateDocumentResult>;
export type UpdateAndReturnParamWithCallback<T = any> = UpdateData & CallbackParam<UpdateAndReturnDocumentResult<T>>;
export interface FileUploaderUploadParam<T> {
    uploadURL: string;
    fileID: string;
    fileContent: T;
}
export interface FileUploaderDownloadParam {
    fileID: string;
    downloadURL: string;
}
export interface FileUploaderResult {
    statusCode: number;
}
export interface FileUploader<FileContent, DownloadResult extends FileUploaderResult> {
    upload(param: FileUploaderUploadParam<FileContent>): Promise<FileUploaderResult>;
    download(param: FileUploaderDownloadParam): Promise<DownloadResult>;
}
export interface CreateStorageOptions<FileContent, DownloadResult extends FileUploaderResult> extends CreateOptions {
    fileUploader: FileUploader<FileContent, DownloadResult>;
    toEnvId: string;
}
export interface FileInfo {
    fileID: string;
    status: number;
    errMsg: string;
}
export interface TempFileInfo extends FileInfo {
    tempFileURL: string;
}
export interface GetUploadFileURLParam {
    cloudPath: string;
}
export interface GetUploadFileURLResult {
    fileID: string;
    uploadURL: string;
    requestID: string;
}
export interface UploadFileParam<T> {
    cloudPath: string;
    fileContent: T;
}
export interface UploadFileResult {
    fileID: string;
    statusCode: number;
}
export interface DownloadFileParam {
    fileID: string;
}
export interface DownloadFileResult {
    statusCode: number;
}
export interface DeleteFileParam {
    fileList: string[];
}
export interface DeleteFileResult {
    fileList: FileInfo[];
}
export interface GetTempFileURLParam {
    fileList: string[];
}
export interface GetTempFileURLResult {
    fileList: TempFileInfo[];
}
export interface GetUploadUrlResult {
    file_id: string;
    upload_url: string;
}
export interface GetDownloadURLResult {
    download_url: string;
}
