export declare class FaasError extends Error {
    httpStatus: number;
    error: number;
    errorMessage: string;
    requestID: string;
    get errCode(): number;
    get errMsg(): string;
    constructor(code: number, message: string);
    static INVALID_PARAM_ERR(paramName: string, message: string): FaasError;
    static NOT_FOUND_ERR(message: string): FaasError;
    static SERVER_ERR(code: number, message: string, requestID: string, httpStatus: number): FaasError;
    static STORAGE_ERR(code: number, message: string, requestID: string): FaasError;
    static NETWORK_ERR(e: Error, requestID: string): FaasError;
}
