import { UpdateData } from '@alipay/faas-db-builder';
import { CallbackParam, CreateDatabaseOptions, DeleteDocumentResult, UpdateAndReturnDocumentResult, UpdateAndReturnParamWithCallback, UpdateDataParamWithCallback, UpdateDocumentResult } from '../types';
export declare class Document {
    private readonly options;
    private readonly collectionName;
    private readonly id;
    private _query?;
    constructor(collectionName: string, id: string, options: CreateDatabaseOptions);
    projection(projection: object): Document;
    field(projection: object): Document;
    update(data: UpdateData): Promise<UpdateDocumentResult>;
    update(data: UpdateDataParamWithCallback): void;
    updateAndReturn<T = any>(data: UpdateData): Promise<UpdateAndReturnDocumentResult<T>>;
    updateAndReturn<T = any>(data: UpdateAndReturnParamWithCallback<T>): void;
    set(data: UpdateData): Promise<UpdateDocumentResult>;
    set(data: UpdateDataParamWithCallback): void;
    remove(): Promise<DeleteDocumentResult>;
    remove(data: CallbackParam<DeleteDocumentResult>): void;
    get<T = any>(): Promise<T | null>;
    get<T = any>(param: CallbackParam<T | null>): void;
    private get query();
}
