import { AggregateCommand, AggregateGeoNearParam, LookupAggregateParam, QueryChainCommand, ReplaceRootParam, SampleAggregateParam, Sort, UnwindParam, bucketAutoParam, bucketParam } from '@alipay/faas-db-builder';
import { CallbackParam, CreateDatabaseOptions } from '../types';
export declare class Aggregate {
    private readonly options;
    private readonly collectionName;
    private readonly builder;
    constructor(collectionName: string, options: CreateDatabaseOptions);
    addFields(fields: Record<string, string | AggregateCommand>): Aggregate;
    count(field: string): Aggregate;
    match(match: QueryChainCommand): Aggregate;
    group(group: object): Aggregate;
    sample(sample: SampleAggregateParam): Aggregate;
    lookup(lookup: LookupAggregateParam): Aggregate;
    project(project: Record<string, boolean | 0 | 1 | object | AggregateCommand>): Aggregate;
    replaceRoot(root: ReplaceRootParam): Aggregate;
    sort(sort: Record<string, Sort | 1 | -1>): Aggregate;
    limit(limit: number): Aggregate;
    skip(skip: number): Aggregate;
    unwind(unwind: string | UnwindParam): Aggregate;
    geoNear(near: AggregateGeoNearParam): Aggregate;
    bucket(bucket: bucketParam): Aggregate;
    bucketAuto(bucketAuto: bucketAutoParam): Aggregate;
    sortByCount(sortByCount: string | object): Aggregate;
    end<T = any>(): Promise<T[]>;
    end<T = any>(param: CallbackParam<T[]>): void;
    private getCollectionPath;
}
