import { CreateStorageOptions, DeleteFileParam, DeleteFileResult, DownloadFileParam, FileUploaderResult, GetTempFileURLParam, GetTempFileURLResult, GetUploadFileURLParam, GetUploadFileURLResult, UploadFileParam, UploadFileResult } from './types';
export interface GetDownloadFileRawResult {
    file_list: Array<{
        file_id: string;
        expire: number;
        status: boolean;
        result_message: string;
        download_url: string;
    }>;
}
export interface DeleteFileRawResult {
    file_list: Array<{
        file_id: string;
        status: boolean;
        result_message: string;
    }>;
}
export declare class Storage<FileContent, DownloadFileResult extends FileUploaderResult> {
    private readonly options;
    constructor(options: CreateStorageOptions<FileContent, DownloadFileResult>);
    private getUploadPath;
    private getDownloadPath;
    private getBatchDeletePath;
    private getBatchDownloadPath;
    private checkCloudPath;
    private checkFileID;
    private formatFileID;
    private getCloudPathFromFileID;
    getUploadFileURL(param: string | GetUploadFileURLParam): Promise<GetUploadFileURLResult>;
    uploadFile(param: UploadFileParam<FileContent>): Promise<UploadFileResult>;
    downloadFile(param: DownloadFileParam): Promise<DownloadFileResult>;
    deleteFile(param: DeleteFileParam): Promise<DeleteFileResult>;
    getTempFileURL(param: GetTempFileURLParam): Promise<GetTempFileURLResult>;
    private request;
}
