import { QueryChainCommand, Sort, UpdateData } from '@alipay/faas-db-builder';
import { CallbackParam, CountDocumentResult, CreateDatabaseOptions, DeleteDocumentResult, UpdateAndReturnDocumentResult, UpdateAndReturnParamWithCallback, UpdateDataParamWithCallback, UpdateDocumentResult } from '../types';
export declare class Query {
    private readonly options;
    private readonly collectionName;
    private readonly builder;
    constructor(collectionName: string, options: CreateDatabaseOptions);
    limit(limit: number): Query;
    skip(skip: number): Query;
    where(match: QueryChainCommand): Query;
    projection(projection: object): Query;
    field(projection: object): Query;
    orderBy(field: string, sort: Sort | string): Query;
    updateAndReturn<T = any>(data: UpdateData): Promise<UpdateAndReturnDocumentResult<T>>;
    updateAndReturn<T = any>(data: UpdateAndReturnParamWithCallback<T>): void;
    update(data: UpdateData): Promise<UpdateDocumentResult>;
    update(data: UpdateDataParamWithCallback): void;
    set(data: UpdateData): Promise<UpdateDocumentResult>;
    set(data: UpdateDataParamWithCallback): void;
    remove(): Promise<DeleteDocumentResult>;
    remove(data: CallbackParam<DeleteDocumentResult>): void;
    get<T = any>(): Promise<Array<T>>;
    get<T = any>(param: CallbackParam<Array<T>>): void;
    count(): Promise<CountDocumentResult>;
    count(param: CallbackParam<CountDocumentResult>): void;
    private getCollectionPath;
}
